/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.model.process;

import io.vlingo.actors.World;
import io.vlingo.lattice.exchange.Exchange;
import io.vlingo.lattice.exchange.NullExchange;
import io.vlingo.lattice.model.object.ObjectTypeRegistry;
import io.vlingo.lattice.model.process.ObjectProcess;
import io.vlingo.lattice.model.process.SourcedProcess;
import io.vlingo.lattice.model.process.StatefulProcess;
import io.vlingo.lattice.model.sourcing.SourcedTypeRegistry;
import io.vlingo.lattice.model.stateful.StatefulTypeRegistry;
import io.vlingo.symbio.store.object.StateObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public final class ProcessTypeRegistry {
    static final String INTERNAL_NAME = UUID.randomUUID().toString();
    private final Map<Class<?>, Info<?>> stores = new HashMap();

    public ProcessTypeRegistry(World world) {
        world.registerDynamic(INTERNAL_NAME, (Object)this);
    }

    public <T> Info<T> info(Class<?> type) {
        return this.stores.get(type);
    }

    public ProcessTypeRegistry register(Info<?> info) {
        this.stores.put(info.processType, info);
        return this;
    }

    public static class StatefulProcessInfo<T>
    extends Info<StatefulProcess<T>> {
        public final StatefulTypeRegistry registry;

        public StatefulProcessInfo(Class<StatefulProcess<T>> processType, String processName, Exchange exchange, StatefulTypeRegistry registry) {
            super(processType, processName, exchange);
            this.registry = registry;
        }

        public StatefulProcessInfo(Class<StatefulProcess<T>> processType, String processName, StatefulTypeRegistry registry) {
            super(processType, processName);
            this.registry = registry;
        }
    }

    public static class SourcedProcessInfo<T extends SourcedProcess<T>>
    extends Info<T> {
        public final SourcedTypeRegistry registry;

        public SourcedProcessInfo(Class<T> processType, String processName, Exchange exchange, SourcedTypeRegistry registry) {
            super(processType, processName, exchange);
            this.registry = registry;
        }

        public SourcedProcessInfo(Class<T> processType, String processName, SourcedTypeRegistry registry) {
            super(processType, processName);
            this.registry = registry;
        }
    }

    public static class ObjectProcessInfo<T extends StateObject>
    extends Info<ObjectProcess<T>> {
        public final ObjectTypeRegistry registry;

        public ObjectProcessInfo(Class<ObjectProcess<T>> processType, String processName, Exchange exchange, ObjectTypeRegistry registry) {
            super(processType, processName, exchange);
            this.registry = registry;
        }

        public ObjectProcessInfo(Class<ObjectProcess<T>> processType, String processName, ObjectTypeRegistry registry) {
            super(processType, processName);
            this.registry = registry;
        }
    }

    public static abstract class Info<T> {
        public final Exchange exchange;
        public final String processName;
        public final Class<T> processType;

        public Info(Class<T> processType, String processName, Exchange exchange) {
            this.processType = processType;
            this.processName = processName;
            this.exchange = exchange;
        }

        public Info(Class<T> processType, String processName) {
            this(processType, processName, NullExchange.Instance);
        }
    }
}

