/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.model.process;

import io.vlingo.common.Completes;
import io.vlingo.lattice.model.Command;
import io.vlingo.lattice.model.DomainEvent;
import io.vlingo.lattice.model.process.Chronicle;
import io.vlingo.lattice.model.process.Process;
import io.vlingo.lattice.model.process.ProcessMessage;
import io.vlingo.lattice.model.process.ProcessTypeRegistry;
import io.vlingo.lattice.model.sourcing.Sourced;
import io.vlingo.symbio.Source;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public abstract class SourcedProcess<T>
extends Sourced<ProcessMessage>
implements Process<T> {
    private final ProcessTypeRegistry.Info<? extends SourcedProcess<T>> info = ((ProcessTypeRegistry)this.stage().world().resolveDynamic(ProcessTypeRegistry.INTERNAL_NAME, ProcessTypeRegistry.class)).info(this.getClass());
    private List<Source<?>> applied = new ArrayList(2);

    protected SourcedProcess() {
        this(null);
    }

    protected SourcedProcess(String streamName) {
        super(streamName);
    }

    @Override
    public Chronicle<T> chronicle() {
        return (Chronicle)this.snapshot();
    }

    @Override
    public void process(Command command) {
        this.applied.add(command);
        this.apply(new ProcessMessage(command));
    }

    @Override
    public <R> Completes<R> process(Command command, Supplier<R> andThen) {
        this.applied.add(command);
        return this.apply(new ProcessMessage(command), andThen);
    }

    @Override
    public void process(DomainEvent event) {
        this.applied.add(event);
        this.apply(new ProcessMessage(event));
    }

    @Override
    public <R> Completes<R> process(DomainEvent event, Supplier<R> andThen) {
        this.applied.add(event);
        return this.apply(new ProcessMessage(event), andThen);
    }

    @Override
    public <C> void processAll(List<Source<C>> sources) {
        this.applied.addAll(sources);
        this.apply(ProcessMessage.wrap(sources));
    }

    @Override
    public <C, R> Completes<R> processAll(List<Source<C>> sources, Supplier<R> andThen) {
        this.applied.addAll(sources);
        return this.apply(ProcessMessage.wrap(sources), andThen);
    }

    @Override
    public void send(Command command) {
        this.info.exchange.send(command);
    }

    @Override
    public void send(DomainEvent event) {
        this.info.exchange.send(event);
    }

    @Override
    protected void afterApply() {
        for (Source<?> source : this.applied) {
            this.info.exchange.send(source);
        }
        this.applied.clear();
    }
}

