/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.model.projection;

import io.vlingo.lattice.model.projection.Projectable;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.State;
import java.util.Collection;
import java.util.Optional;

public abstract class AbstractProjectable
implements Projectable {
    private final Collection<Entry<?>> entries;
    private final String projectionId;
    private final State<?> state;
    private int index;

    public AbstractProjectable(State<?> state, Collection<Entry<?>> entries, String projectionId) {
        this.state = state;
        this.entries = entries;
        this.projectionId = projectionId;
    }

    @Override
    public String[] becauseOf() {
        int count = (this.state != null ? 1 : 0) + this.entries().size();
        String[] becauseOf = new String[count];
        this.index = 0;
        if (this.state != null) {
            becauseOf[0] = this.state.metadata.operation;
            ++this.index;
        }
        this.entries().stream().map(entry -> entry.typeName()).forEach(type -> {
            becauseOf[this.index++] = type;
        });
        return becauseOf;
    }

    @Override
    public byte[] dataAsBytes() {
        throw new UnsupportedOperationException("Projectable data is not binary compatible.");
    }

    @Override
    public String dataAsText() {
        throw new UnsupportedOperationException("Projectable data is not text compatible.");
    }

    @Override
    public int dataVersion() {
        if (this.state == null) {
            if (this.hasEntries()) {
                return this.lastEntry().entryVersion();
            }
            return -1;
        }
        return this.state.dataVersion;
    }

    @Override
    public String dataId() {
        if (this.state == null) {
            return "";
        }
        return this.state.id;
    }

    @Override
    public Collection<Entry<?>> entries() {
        return this.entries;
    }

    @Override
    public boolean hasEntries() {
        return this.entries != null && !this.entries.isEmpty();
    }

    @Override
    public String metadata() {
        if (this.state == null) {
            return "";
        }
        return this.state.metadata.value;
    }

    @Override
    public boolean hasObject() {
        if (this.state == null) {
            return false;
        }
        return this.state.metadata.hasObject();
    }

    @Override
    public <T> T object() {
        if (this.state == null) {
            return null;
        }
        return (T)this.state.metadata.object;
    }

    @Override
    public <T> Optional<T> optionalObject() {
        if (this.state == null) {
            return Optional.empty();
        }
        return this.state.metadata.optionalObject();
    }

    @Override
    public String projectionId() {
        return this.projectionId;
    }

    @Override
    public boolean hasState() {
        return this.state != null;
    }

    @Override
    public String type() {
        if (this.state == null) {
            return "null";
        }
        return this.state.type;
    }

    @Override
    public int typeVersion() {
        if (this.state == null) {
            return -1;
        }
        return this.state.typeVersion;
    }

    public String toString() {
        return "Projectable [projectionId=" + this.projectionId + ", state=" + this.state + ", entries=" + this.entries + ", index=" + this.index + "]";
    }

    protected State<byte[]> binaryState() {
        return this.state;
    }

    protected State<String> textState() {
        return this.state;
    }

    private Entry<?> lastEntry() {
        return this.entries.stream().reduce((first, second) -> second).get();
    }
}

