/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.model.projection;

import io.vlingo.lattice.model.projection.Projection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MatchableProjections {
    private static final String Wildcard = "*";
    private final Map<Cause, List<Projection>> mappedProjections = new HashMap<Cause, List<Projection>>();

    public List<Projection> matchProjections(String ... actualCauses) {
        return this.mappedProjections.keySet().stream().filter(cause -> cause.matches(actualCauses)).map(cause -> this.mappedProjections.get(cause)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public void mayDispatchTo(Projection projection, String[] whenMatchingCauses) {
        for (String whenMatchingCause : whenMatchingCauses) {
            Cause cause = Cause.determineFor(whenMatchingCause);
            List<Projection> projections = this.mappedProjections.get(cause);
            if (projections == null) {
                projections = new ArrayList<Projection>(1);
                this.mappedProjections.put(cause, projections);
            }
            projections.add(projection);
        }
    }

    public String toString() {
        return "MatchableProjections[" + this.mappedProjections + "]";
    }

    private static class EntireCause
    extends Cause {
        EntireCause(String value) {
            super(value);
        }

        @Override
        boolean matches(String ... actualCauses) {
            for (String cause : actualCauses) {
                if (!cause.equals(this.value)) continue;
                return true;
            }
            return false;
        }
    }

    private static class EndsWithCause
    extends Cause {
        EndsWithCause(String value) {
            super(value);
        }

        @Override
        boolean matches(String ... actualCauses) {
            for (String cause : actualCauses) {
                if (!cause.endsWith(this.value)) continue;
                return true;
            }
            return false;
        }
    }

    private static class ContainsCause
    extends Cause {
        ContainsCause(String value) {
            super(value);
        }

        @Override
        boolean matches(String ... actualCauses) {
            for (String cause : actualCauses) {
                if (!cause.contains(this.value)) continue;
                return true;
            }
            return false;
        }
    }

    private static class BeginsWithCause
    extends Cause {
        BeginsWithCause(String value) {
            super(value);
        }

        @Override
        boolean matches(String ... actualCauses) {
            for (String cause : actualCauses) {
                if (!cause.startsWith(this.value)) continue;
                return true;
            }
            return false;
        }
    }

    private static abstract class Cause {
        final String value;

        static Cause determineFor(String matchableCause) {
            boolean beginsWithWildcard = matchableCause.startsWith(MatchableProjections.Wildcard);
            boolean endsWithWildcard = matchableCause.endsWith(MatchableProjections.Wildcard);
            if (beginsWithWildcard && endsWithWildcard) {
                return new ContainsCause(matchableCause);
            }
            if (beginsWithWildcard) {
                return new EndsWithCause(matchableCause);
            }
            if (endsWithWildcard) {
                return new BeginsWithCause(matchableCause);
            }
            return new EntireCause(matchableCause);
        }

        Cause(String value) {
            this.value = value.replaceAll("\\*", "");
        }

        abstract boolean matches(String ... var1);

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            return this.value.equals(((Cause)other).value);
        }

        public int hashCode() {
            return 31 * this.value.hashCode();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[value=" + this.value + "]";
        }
    }
}

