/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.model.projection;

import io.vlingo.actors.Actor;
import io.vlingo.common.Completes;
import io.vlingo.common.Scheduled;
import io.vlingo.lattice.model.projection.MultiConfirming;
import io.vlingo.lattice.model.projection.Projectable;
import io.vlingo.lattice.model.projection.ProjectionControl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MultiConfirmingProjectionControlActor
extends Actor
implements MultiConfirming,
ProjectionControl,
Scheduled<Object> {
    private final long expiration;
    private final Map<String, Confirmable> confirmables;
    private final ProjectionControl projectionControl;

    public MultiConfirmingProjectionControlActor(ProjectionControl projectionControl, long expiration) {
        this.projectionControl = projectionControl;
        this.confirmables = new HashMap<String, Confirmable>();
        this.expiration = expiration;
    }

    @Override
    public void manageConfirmationsFor(Projectable projectable, int count) {
        long expiresBy = new Date().getTime() + this.expiration;
        this.confirmables.put(projectable.projectionId(), new Confirmable(projectable, count, 0, expiresBy));
    }

    @Override
    public Completes<List<Projectable>> managedConfirmations() {
        List managedConfirmations = this.confirmables.values().stream().map(confirmable -> confirmable.projectable).collect(Collectors.toList());
        return this.completes().with(Collections.unmodifiableList(managedConfirmations));
    }

    @Override
    public void confirmProjected(String projectionId) {
        Confirmable confirmable = this.confirmables.get(projectionId);
        if (confirmable == null) {
            return;
        }
        int total = confirmable.total + 1;
        if (confirmable.count < total) {
            this.confirmables.put(projectionId, confirmable.incrementTotal());
        } else {
            ProjectionControl.confirmerFor(confirmable.projectable, this.projectionControl).confirm();
            this.confirmables.remove(projectionId);
        }
    }

    public void intervalSignal(Scheduled<Object> scheduled, Object data) {
        long currentTime = new Date().getTime();
        ArrayList<String> expiredKeys = new ArrayList<String>();
        for (String projectionId : this.confirmables.keySet()) {
            Confirmable confirmable = this.confirmables.get(projectionId);
            if (confirmable.expiresBy > currentTime) continue;
            expiredKeys.add(projectionId);
        }
        for (String projectionId : expiredKeys) {
            this.logger().info("Removing expired confirmable: " + projectionId);
            this.confirmables.remove(projectionId);
        }
    }

    private class Confirmable {
        final Projectable projectable;
        final int count;
        final int total;
        final long expiresBy;

        public Confirmable(Projectable projectable, int count, int total, long expiresBy) {
            this.projectable = projectable;
            this.count = count;
            this.total = total;
            this.expiresBy = expiresBy;
        }

        public Confirmable incrementTotal() {
            return new Confirmable(this.projectable, this.count, this.total + 1, this.expiresBy);
        }
    }
}

