/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.model.projection;

import io.vlingo.actors.Actor;
import io.vlingo.actors.ActorInstantiator;
import io.vlingo.lattice.model.projection.BinaryProjectionDispatcherActor;
import io.vlingo.lattice.model.projection.Projection;
import io.vlingo.lattice.model.projection.TextProjectionDispatcherActor;
import io.vlingo.symbio.Source;
import java.util.Collection;
import java.util.Optional;

public interface ProjectionDispatcher {
    public void projectTo(Projection var1, String[] var2);

    public static class TextProjectionDispatcherInstantiator
    implements ActorInstantiator<TextProjectionDispatcherActor> {
        private static final long serialVersionUID = -732875432321359779L;
        private final Collection<ProjectToDescription> projectToDescriptions;
        private final long multiConfirmationsExpiration;

        public TextProjectionDispatcherInstantiator(Collection<ProjectToDescription> projectToDescriptions) {
            this(projectToDescriptions, 3000L);
        }

        public TextProjectionDispatcherInstantiator(Collection<ProjectToDescription> projectToDescriptions, long multiConfirmationsExpiration) {
            this.projectToDescriptions = projectToDescriptions;
            this.multiConfirmationsExpiration = multiConfirmationsExpiration;
        }

        public TextProjectionDispatcherActor instantiate() {
            return new TextProjectionDispatcherActor(this.projectToDescriptions, this.multiConfirmationsExpiration);
        }

        public Class<TextProjectionDispatcherActor> type() {
            return TextProjectionDispatcherActor.class;
        }
    }

    public static class BinaryProjectionDispatcherInstantiator
    implements ActorInstantiator<BinaryProjectionDispatcherActor> {
        private static final long serialVersionUID = -8778106325710566773L;
        private final Collection<ProjectToDescription> projectToDescriptions;
        private final long multiConfirmationsExpiration;

        public BinaryProjectionDispatcherInstantiator(Collection<ProjectToDescription> projectToDescriptions) {
            this(projectToDescriptions, 3000L);
        }

        public BinaryProjectionDispatcherInstantiator(Collection<ProjectToDescription> projectToDescriptions, long multiConfirmationsExpiration) {
            this.projectToDescriptions = projectToDescriptions;
            this.multiConfirmationsExpiration = multiConfirmationsExpiration;
        }

        public BinaryProjectionDispatcherActor instantiate() {
            return new BinaryProjectionDispatcherActor(this.projectToDescriptions, this.multiConfirmationsExpiration);
        }

        public Class<BinaryProjectionDispatcherActor> type() {
            return BinaryProjectionDispatcherActor.class;
        }
    }

    public static class ProjectToDescription {
        public final Class<? extends Actor> projectionType;
        public final String[] becauseOf;
        public final Optional<Object> constructionParameter;

        public static ProjectToDescription with(Class<? extends Actor> projectionType, Class<? extends Source<?>> ... becauseOf) {
            return ProjectToDescription.with(projectionType, Optional.empty(), becauseOf);
        }

        public static ProjectToDescription with(Class<? extends Actor> projectionType, Optional<Object> constructionParameter, Class<? extends Source<?>> ... becauseOf) {
            String[] representations = new String[becauseOf.length];
            int index = 0;
            for (Class<Source<?>> clazz : becauseOf) {
                representations[index++] = clazz.getName();
            }
            return new ProjectToDescription(projectionType, constructionParameter, representations);
        }

        public static ProjectToDescription with(Class<? extends Actor> projectionType, Package ... contentsOf) {
            return ProjectToDescription.with(projectionType, Optional.empty(), contentsOf);
        }

        public static ProjectToDescription with(Class<? extends Actor> projectionType, Optional<Object> constructionParameter, Package ... contentsOf) {
            String[] representations = new String[contentsOf.length];
            int index = 0;
            for (Package p : contentsOf) {
                representations[index++] = p.getName() + "*";
            }
            return new ProjectToDescription(projectionType, constructionParameter, representations);
        }

        public static ProjectToDescription with(Class<? extends Actor> projectionType, String ... becauseOf) {
            return ProjectToDescription.with(projectionType, Optional.empty(), becauseOf);
        }

        public static ProjectToDescription with(Class<? extends Actor> projectionType, Optional<Object> constructionParameter, String ... becauseOf) {
            return new ProjectToDescription(projectionType, constructionParameter, becauseOf);
        }

        public ProjectToDescription(Class<? extends Actor> projectionType, String ... becauseOf) {
            this(projectionType, Optional.empty(), becauseOf);
        }

        public ProjectToDescription(Class<? extends Actor> projectionType, Optional<Object> constructionParameter, String ... becauseOf) {
            if (!Projection.class.isAssignableFrom(projectionType)) {
                throw new IllegalArgumentException("Class of projectionType must extend Actor and implement Projection.");
            }
            this.projectionType = projectionType;
            this.becauseOf = becauseOf;
            this.constructionParameter = constructionParameter;
        }
    }
}

