/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.model.projection;

import io.vlingo.actors.Definition;
import io.vlingo.actors.Protocols;
import io.vlingo.lattice.model.projection.AbstractProjectionDispatcherActor;
import io.vlingo.lattice.model.projection.MultiConfirming;
import io.vlingo.lattice.model.projection.MultiConfirmingProjectionControlActor;
import io.vlingo.lattice.model.projection.Projectable;
import io.vlingo.lattice.model.projection.Projection;
import io.vlingo.lattice.model.projection.ProjectionControl;
import io.vlingo.lattice.model.projection.ProjectionDispatcher;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.State;
import io.vlingo.symbio.store.Result;
import io.vlingo.symbio.store.dispatch.ConfirmDispatchedResultInterest;
import io.vlingo.symbio.store.dispatch.Dispatchable;
import io.vlingo.symbio.store.dispatch.Dispatcher;
import io.vlingo.symbio.store.dispatch.DispatcherControl;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public abstract class ProjectionDispatcherActor<E extends Entry<?>, RS extends State<?>>
extends AbstractProjectionDispatcherActor
implements Dispatcher<Dispatchable<E, RS>>,
ProjectionDispatcher,
ConfirmDispatchedResultInterest {
    private ConfirmDispatchedResultInterest interest = (ConfirmDispatchedResultInterest)this.selfAs(ConfirmDispatchedResultInterest.class);
    private DispatcherControl control;
    private final MultiConfirming multiConfirming;
    private final ProjectionControl multiConfirmingProjectionControl;
    private final ProjectionControl projectionControl = new ProjectionControl(){

        @Override
        public void confirmProjected(String projectionId) {
            if (ProjectionDispatcherActor.this.control != null) {
                ProjectionDispatcherActor.this.control.confirmDispatched(projectionId, ProjectionDispatcherActor.this.interest);
            } else if (ProjectionDispatcherActor.this.requiresDispatchedConfirmation()) {
                ProjectionDispatcherActor.this.logger().error("WARNING: ProjectionDispatcher control is not set; unconfirmed: " + projectionId);
            }
        }
    };

    protected ProjectionDispatcherActor() {
        this(Arrays.asList(new ProjectionDispatcher.ProjectToDescription[0]), 3000L);
    }

    protected ProjectionDispatcherActor(Collection<ProjectionDispatcher.ProjectToDescription> projectToDescriptions, long multiConfirmationsExpiration) {
        super(projectToDescriptions);
        Protocols protocols = this.childActorFor(new Class[]{MultiConfirming.class, ProjectionControl.class}, Definition.has(MultiConfirmingProjectionControlActor.class, (List)Definition.parameters((Object[])new Object[]{this.projectionControl, multiConfirmationsExpiration})));
        this.multiConfirming = (MultiConfirming)protocols.get(0);
        this.multiConfirmingProjectionControl = (ProjectionControl)protocols.get(1);
    }

    public void controlWith(DispatcherControl control) {
        this.control = control;
    }

    public void confirmDispatchedResultedIn(Result result, String dispatchId) {
    }

    protected abstract boolean requiresDispatchedConfirmation();

    protected void dispatch(String dispatchId, Projectable projectable) {
        List<Projection> projections = this.projectionsFor(projectable.becauseOf());
        int count = projections.size();
        if (count > 1) {
            this.multiConfirming.manageConfirmationsFor(projectable, count);
        }
        for (Projection projection : projections) {
            projection.projectWith(projectable, count > 1 ? this.multiConfirmingProjectionControl : this.projectionControl);
        }
    }
}

