/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.model.projection;

import io.vlingo.actors.Actor;
import io.vlingo.common.Outcome;
import io.vlingo.lattice.CompositeIdentitySupport;
import io.vlingo.lattice.model.DomainEvent;
import io.vlingo.lattice.model.IdentifiedDomainEvent;
import io.vlingo.lattice.model.projection.Projectable;
import io.vlingo.lattice.model.projection.Projection;
import io.vlingo.lattice.model.projection.ProjectionControl;
import io.vlingo.symbio.DefaultTextEntryAdapter;
import io.vlingo.symbio.DefaultTextStateAdapter;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.EntryAdapter;
import io.vlingo.symbio.Metadata;
import io.vlingo.symbio.Source;
import io.vlingo.symbio.State;
import io.vlingo.symbio.StateAdapter;
import io.vlingo.symbio.store.Result;
import io.vlingo.symbio.store.StorageException;
import io.vlingo.symbio.store.state.StateStore;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;

public abstract class StateStoreProjectionActor<T>
extends Actor
implements Projection,
CompositeIdentitySupport,
StateStore.ReadResultInterest,
StateStore.WriteResultInterest {
    private final List<Source<?>> adaptedSources;
    private final EntryAdapter<Source<?>, Entry<?>> entryAdapter;
    private final StateAdapter<Object, State<?>> stateAdapter;
    private final StateStore.ReadResultInterest readInterest;
    private final StateStore.WriteResultInterest writeInterest;
    private final StateStore stateStore;

    public StateStoreProjectionActor(StateStore stateStore) {
        this(stateStore, StateStoreProjectionActor.defaultTextStateAdapter(), StateStoreProjectionActor.defaultTextEntryAdapter());
    }

    public StateStoreProjectionActor(StateStore stateStore, StateAdapter<Object, State<?>> stateAdapter, EntryAdapter<Source<?>, Entry<?>> entryAdapter) {
        this.stateStore = stateStore;
        this.stateAdapter = stateAdapter;
        this.entryAdapter = entryAdapter;
        this.readInterest = (StateStore.ReadResultInterest)this.selfAs(StateStore.ReadResultInterest.class);
        this.writeInterest = (StateStore.WriteResultInterest)this.selfAs(StateStore.WriteResultInterest.class);
        this.adaptedSources = new ArrayList(2);
    }

    @Override
    public void projectWith(Projectable projectable, ProjectionControl control) {
        this.upsertFor(projectable, control);
    }

    protected boolean alwaysWrite() {
        return true;
    }

    protected T currentDataFor(Projectable projectable) {
        return projectable.object();
    }

    protected int currentDataVersionFor(Projectable projectable, T previousData, int previousVersion) {
        return this.alwaysWrite() ? projectable.dataVersion() : (previousVersion == -1 ? 1 : previousVersion + 1);
    }

    protected String dataIdFor(Projectable projectable) {
        String dataId = projectable.dataId();
        if (dataId.isEmpty()) {
            try {
                dataId = this.typedToIdentifiedDomainEvent(this.sources().get(0)).identity();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dataId;
    }

    protected <S extends Source<?>, E extends Entry<?>> EntryAdapter<S, E> entryAdapter() {
        return this.entryAdapter;
    }

    protected T merge(T previousData, int previousVersion, T currentData, int currentVersion) {
        return currentData;
    }

    protected T merge(T previousData, int previousVersion, T currentData, int currentVersion, List<Source<?>> sources) {
        return this.merge(previousData, previousVersion, currentData, currentVersion);
    }

    protected void prepareForMergeWith(Projectable projectable) {
        this.adaptedSources.clear();
        for (Entry<?> entry : projectable.entries()) {
            this.adaptedSources.add(this.entryAdapter.anyTypeFromEntry(entry));
        }
    }

    protected List<Source<?>> sources() {
        return this.adaptedSources;
    }

    protected <ST extends State<?>> StateAdapter<?, ST> stateAdapter() {
        return this.stateAdapter;
    }

    protected void upsertFor(Projectable projectable, ProjectionControl control) {
        T currentData = this.currentDataFor(projectable);
        this.prepareForMergeWith(projectable);
        String dataId = this.dataIdFor(projectable);
        BiConsumer<Object, Integer> upserter = (previousData, previousVersion) -> {
            int currentDataVersion = this.currentDataVersionFor(projectable, (T)previousData, (int)previousVersion);
            Object data = this.merge((T)previousData, (int)previousVersion, currentData, currentDataVersion, this.sources());
            ProjectionControl.Confirmer confirmer = ProjectionControl.confirmerFor(projectable, control);
            if (this.alwaysWrite() || !data.equals(previousData)) {
                this.stateStore.write(dataId, data, currentDataVersion, this.writeInterest, (Object)confirmer);
            } else {
                this.confirmProjection(confirmer);
            }
        };
        this.stowMessages(new Class[]{StateStore.ReadResultInterest.class, StateStore.WriteResultInterest.class});
        this.stateStore.read(dataId, currentData.getClass(), this.readInterest, upserter);
    }

    protected <S> S typed(Object state) {
        return (S)state;
    }

    protected <E> E typed(DomainEvent event) {
        return (E)((Object)event);
    }

    protected <E> E typed(Source<?> source) {
        return (E)source;
    }

    protected IdentifiedDomainEvent typedToIdentifiedDomainEvent(Source<?> source) {
        return (IdentifiedDomainEvent)source;
    }

    public final <S> void readResultedIn(Outcome<StorageException, Result> outcome, String id, S state, int stateVersion, Metadata metadata, Object object) {
        outcome.andThen(result -> {
            ((BiConsumer)object).accept(state, stateVersion);
            return result;
        }).otherwise(cause -> {
            if (cause.result.isNotFound()) {
                ((BiConsumer)object).accept(null, -1);
            } else {
                this.logger().info("Query state not read for update because: " + cause.getMessage(), (Throwable)cause);
            }
            return cause.result;
        });
    }

    public final <S, C> void writeResultedIn(Outcome<StorageException, Result> outcome, String id, S state, int stateVersion, List<Source<C>> sources, Object object) {
        outcome.andThen(result -> {
            this.confirmProjection((ProjectionControl.Confirmer)object);
            return result;
        }).otherwise(cause -> {
            this.disperseStowedMessages();
            this.logger().info("Query state not written for update because: " + cause.getMessage(), (Throwable)cause);
            return cause.result;
        });
    }

    private static <S extends Source<?>, E extends Entry<?>> EntryAdapter<S, E> defaultTextEntryAdapter() {
        return new DefaultTextEntryAdapter();
    }

    private static <S, ST extends State<?>> StateAdapter<S, ST> defaultTextStateAdapter() {
        return new DefaultTextStateAdapter();
    }

    private void confirmProjection(ProjectionControl.Confirmer confirmer) {
        confirmer.confirm();
        this.disperseStowedMessages();
    }
}

