/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.model.sourcing;

import io.vlingo.actors.CompletesEventually;
import io.vlingo.actors.CompletionSupplier;
import io.vlingo.actors.Stoppable;
import io.vlingo.actors.testkit.TestContext;
import io.vlingo.actors.testkit.TestState;
import io.vlingo.common.Completes;
import io.vlingo.common.Outcome;
import io.vlingo.lattice.model.ApplyFailedException;
import io.vlingo.lattice.model.EntityActor;
import io.vlingo.lattice.model.sourcing.SourcedTypeRegistry;
import io.vlingo.symbio.Metadata;
import io.vlingo.symbio.Source;
import io.vlingo.symbio.State;
import io.vlingo.symbio.store.Result;
import io.vlingo.symbio.store.StorageException;
import io.vlingo.symbio.store.journal.Journal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public abstract class Sourced<T>
extends EntityActor
implements Journal.AppendResultInterest {
    private static final Map<Class<Sourced<Source<?>>>, Map<Class<Source<?>>, BiConsumer<Sourced<?>, Source<?>>>> registeredConsumers = new ConcurrentHashMap();
    protected final String streamName;
    private TestContext testContext;
    private int currentVersion;
    private SourcedTypeRegistry.Info<?> journalInfo;
    private Journal.AppendResultInterest interest;

    public static <SOURCED extends Sourced<?>, SOURCE extends Source<?>> void registerConsumer(Class<SOURCED> sourcedType, Class<SOURCE> sourceType, BiConsumer<SOURCED, SOURCE> consumer) {
        Map<Class<Source<?>>, BiConsumer<Sourced<?>, Source<?>>> sourcedTypeMap = registeredConsumers.get(sourcedType);
        if (sourcedTypeMap == null) {
            sourcedTypeMap = new ConcurrentHashMap();
            registeredConsumers.put(sourcedType, sourcedTypeMap);
        }
        sourcedTypeMap.put(sourceType, consumer);
    }

    protected Sourced() {
        this(null);
    }

    protected Sourced(String streamName) {
        this.streamName = streamName != null ? streamName : this.address().idString();
        this.currentVersion = 0;
        this.journalInfo = this.info();
        this.interest = (Journal.AppendResultInterest)this.selfAs(Journal.AppendResultInterest.class);
    }

    public void start() {
        super.start();
        this.restore();
    }

    public void viewTestStateInitialization(TestContext context) {
        if (context != null) {
            this.testContext = context;
            this.testContext.initialReferenceValueOf(new CopyOnWriteArrayList());
        }
    }

    public TestState viewTestState() {
        TestState testState = new TestState();
        testState.putValue("applied", this.testContext.referenceValue());
        return testState;
    }

    protected final void apply(List<Source<T>> sources) {
        this.apply(sources, this.metadata(), null);
    }

    protected final <R> Completes<R> apply(List<Source<T>> sources, Supplier<R> andThen) {
        return this.apply(sources, this.metadata(), andThen);
    }

    protected final <R> Completes<R> apply(List<Source<T>> sources, Metadata metadata, Supplier<R> andThen) {
        this.beforeApply(sources);
        Journal<?> journal = this.journalInfo.journal();
        this.stowMessages(new Class[]{Journal.AppendResultInterest.class});
        journal.appendAllWith(this.streamName, this.nextVersion(), sources, metadata, this.snapshot(), this.interest, (Object)CompletionSupplier.supplierOrNull(andThen, (CompletesEventually)this.completesEventually()));
        return andThen == null ? null : this.completes();
    }

    protected final void apply(Source<T> source) {
        this.apply(source, this.metadata(), null);
    }

    protected final <R> Completes<R> apply(Source<T> source, Supplier<R> andThen) {
        return this.apply(source, this.metadata(), andThen);
    }

    protected final <R> Completes<R> apply(Source<T> source, Metadata metadata, Supplier<R> andThen) {
        List<Source<T>> toApply = this.wrap(source);
        this.beforeApply(toApply);
        Journal<?> journal = this.journalInfo.journal();
        this.stowMessages(new Class[]{Journal.AppendResultInterest.class});
        journal.appendAllWith(this.streamName, this.nextVersion(), toApply, metadata, this.snapshot(), this.interest, (Object)CompletionSupplier.supplierOrNull(andThen, (CompletesEventually)this.completesEventually()));
        return andThen == null ? null : this.completes();
    }

    protected List<Source<T>> asList(Source<T> ... sources) {
        return Arrays.asList(sources);
    }

    protected void afterApply() {
    }

    protected Optional<ApplyFailedException> afterApplyFailed(ApplyFailedException exception) {
        return Optional.of(exception);
    }

    protected void beforeApply(List<Source<T>> sources) {
        if (this.testContext != null) {
            List all = (List)this.testContext.referenceValue();
            all.addAll(sources);
            this.testContext.referenceValueTo((Object)all);
        }
    }

    protected int currentVersion() {
        return this.currentVersion;
    }

    protected Metadata metadata() {
        return Metadata.nullMetadata();
    }

    protected int nextVersion() {
        return this.currentVersion + 1;
    }

    protected <SNAPSHOT> void restoreSnapshot(SNAPSHOT snapshot, int currentVersion) {
    }

    protected <SNAPSHOT> SNAPSHOT snapshot() {
        return null;
    }

    protected String streamNameFrom(String separator, String ... streamNameSegments) {
        StringBuilder builder = new StringBuilder();
        builder.append(streamNameSegments[0]);
        for (int idx = 1; idx < streamNameSegments.length; ++idx) {
            builder.append(separator).append(streamNameSegments[idx]);
        }
        return builder.toString();
    }

    protected String[] streamNameSegmentsFrom(String separator, String streamName) {
        return streamName.split(Pattern.quote(separator));
    }

    public final <S, ST> void appendResultedIn(Outcome<StorageException, Result> outcome, String streamName, int streamVersion, Source<S> source, Optional<ST> snapshot, Object supplier) {
        this.appendResultedIn(outcome, streamName, streamVersion, source, Metadata.nullMetadata(), snapshot, supplier);
    }

    public final <S, ST> void appendAllResultedIn(Outcome<StorageException, Result> outcome, String streamName, int streamVersion, List<Source<S>> sources, Optional<ST> snapshot, Object supplier) {
        this.appendAllResultedIn(outcome, streamName, streamVersion, sources, Metadata.nullMetadata(), snapshot, supplier);
    }

    public final <S, STT> void appendResultedIn(Outcome<StorageException, Result> outcome, String streamName, int streamVersion, Source<S> source, Metadata metadata, Optional<STT> snapshot, Object supplier) {
        outcome.andThen(result -> {
            this.restoreSnapshot(snapshot, this.currentVersion);
            this.applyResultVersioned(source);
            this.afterApply();
            this.completeUsing(supplier);
            this.disperseStowedMessages();
            return result;
        }).otherwise(cause -> {
            ApplyFailedException.Applicable<Object> applicable = new ApplyFailedException.Applicable<Object>(null, Arrays.asList(source), metadata, (CompletionSupplier)supplier);
            String message = "Source (count 1) not appended for: " + this.type() + "(" + this.streamName + ") because: " + cause.result + " with: " + cause.getMessage();
            ApplyFailedException exception = new ApplyFailedException(applicable, message, (Throwable)cause);
            Optional<ApplyFailedException> maybeException = this.afterApplyFailed(exception);
            this.disperseStowedMessages();
            if (maybeException.isPresent()) {
                this.logger().error(message, (Throwable)maybeException.get());
                throw maybeException.get();
            }
            this.logger().error(message, (Throwable)exception);
            return cause.result;
        });
    }

    public final <STT, ST> void appendAllResultedIn(Outcome<StorageException, Result> outcome, String streamName, int streamVersion, List<Source<STT>> sources, Metadata metadata, Optional<ST> snapshot, Object supplier) {
        outcome.andThen(result -> {
            this.restoreSnapshot(snapshot, this.currentVersion);
            for (Source source : sources) {
                this.applyResultVersioned(source);
            }
            this.afterApply();
            this.completeUsing(supplier);
            this.disperseStowedMessages();
            return result;
        }).otherwise(cause -> {
            ApplyFailedException.Applicable<Object> applicable = new ApplyFailedException.Applicable<Object>(null, sources, metadata, (CompletionSupplier)supplier);
            String message = "Source (count " + sources.size() + ") not appended for: " + this.type() + "(" + this.streamName + ") because: " + cause.result + " with: " + cause.getMessage();
            ApplyFailedException exception = new ApplyFailedException(applicable, message, (Throwable)cause);
            Optional<ApplyFailedException> maybeException = this.afterApplyFailed(exception);
            this.disperseStowedMessages();
            if (maybeException.isPresent()) {
                this.logger().error(message, (Throwable)maybeException.get());
                throw maybeException.get();
            }
            this.logger().error(message, (Throwable)exception);
            return cause.result;
        });
    }

    private <STT> void applyResultVersioned(Source<STT> source) {
        this.applySource(source);
        ++this.currentVersion;
    }

    private <STT> void applySource(Source<STT> source) {
        BiConsumer<Sourced<?>, Source<?>> consumer = null;
        for (Class<?> type = ((Object)((Object)this)).getClass(); type != Sourced.class; type = type.getSuperclass()) {
            Map<Class<Source<?>>, BiConsumer<Sourced<?>, Source<?>>> sourcedTypeMap = registeredConsumers.get(type);
            if (sourcedTypeMap == null || (consumer = sourcedTypeMap.get(source.getClass())) == null) continue;
            consumer.accept(this, source);
            break;
        }
        if (consumer == null) {
            throw new IllegalStateException("No such Sourced type.");
        }
    }

    private void completeUsing(Object supplier) {
        if (supplier != null) {
            ((CompletionSupplier)supplier).complete();
        }
    }

    private SourcedTypeRegistry.Info<?> info() {
        try {
            return ((SourcedTypeRegistry)this.stage().world().resolveDynamic(SourcedTypeRegistry.INTERNAL_NAME, SourcedTypeRegistry.class)).info(((Object)((Object)this)).getClass());
        }
        catch (Exception e) {
            String message = ((Object)((Object)this)).getClass().getSimpleName() + ": Info not registered with SourcedTypeRegistry.";
            this.logger().error(message);
            throw new IllegalStateException(message);
        }
    }

    @Override
    protected final void restore() {
        this.stowMessages(new Class[]{Stoppable.class});
        ((Completes)this.journalInfo.journal.streamReader(((Object)((Object)this)).getClass().getSimpleName()).andThenTo(reader -> reader.streamFor(this.streamName))).andThenConsume(stream -> {
            this.restoreSnapshot(stream.snapshot);
            this.restoreFrom(this.journalInfo.entryAdapterProvider.asSources(stream.entries), stream.streamVersion);
            this.disperseStowedMessages();
        }).otherwiseConsume(stream -> this.disperseStowedMessages()).recoverFrom(cause -> {
            this.disperseStowedMessages();
            String message = "Stream not recovered for: " + this.type() + "(" + this.streamName + ") because: " + cause.getMessage();
            throw new StorageException(Result.Failure, message, (Throwable)cause);
        });
    }

    private void restoreFrom(List<Source<T>> stream, int currentVersion) {
        for (Source<T> source : stream) {
            this.applySource(source);
        }
        this.currentVersion = currentVersion;
    }

    private void restoreSnapshot(State<?> snapshot) {
        if (snapshot != null && !snapshot.isNull()) {
            this.restoreSnapshot(this.journalInfo.stateAdapterProvider.fromRaw(snapshot), this.currentVersion);
        }
    }

    private String type() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    private List<Source<T>> wrap(Source<T> source) {
        return Arrays.asList(source);
    }

    private List<Source<T>> wrap(Source<T>[] sources) {
        return Arrays.asList(sources);
    }
}

