/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.model.sourcing;

import io.vlingo.actors.Actor;
import io.vlingo.actors.World;
import io.vlingo.lattice.model.sourcing.Sourced;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.EntryAdapter;
import io.vlingo.symbio.EntryAdapterProvider;
import io.vlingo.symbio.Source;
import io.vlingo.symbio.State;
import io.vlingo.symbio.StateAdapter;
import io.vlingo.symbio.StateAdapterProvider;
import io.vlingo.symbio.store.dispatch.Dispatchable;
import io.vlingo.symbio.store.dispatch.Dispatcher;
import io.vlingo.symbio.store.journal.Journal;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;

public final class SourcedTypeRegistry {
    static final String INTERNAL_NAME = UUID.randomUUID().toString();
    private final Map<Class<?>, Info<?>> stores = new ConcurrentHashMap();

    public static <A extends Actor, S extends Sourced<?>> SourcedTypeRegistry register(World world, Class<A> journalType, Dispatcher<Dispatchable<Entry<?>, State<?>>> dispatcher, Class<S> ... sourcedTypes) {
        return new SourcedTypeRegistry(world, journalType, dispatcher, sourcedTypes);
    }

    public SourcedTypeRegistry(World world) {
        world.registerDynamic(INTERNAL_NAME, (Object)this);
    }

    public <A extends Actor, S extends Sourced<?>> SourcedTypeRegistry(World world, Class<A> journalType, Dispatcher<Dispatchable<Entry<?>, State<?>>> dispatcher, Class<S> ... sourcedTypes) {
        this(world);
        Journal journal = (Journal)world.actorFor(Journal.class, journalType, new Object[]{dispatcher});
        EntryAdapterProvider.instance((World)world);
        for (Class clazz : sourcedTypes) {
            this.register(new Info(journal, clazz, clazz.getSimpleName()));
        }
    }

    public Info<?> info(Class<?> type) {
        return this.stores.get(type);
    }

    public <T> SourcedTypeRegistry register(Info<T> info) {
        this.stores.put(info.sourcedType, info);
        return this;
    }

    public static class Info<T> {
        public final EntryAdapterProvider entryAdapterProvider;
        public final StateAdapterProvider stateAdapterProvider;
        public final Journal<T> journal;
        public final String sourcedName;
        public final Class<Sourced<T>> sourcedType;

        public Info(Journal<T> journal, Class<Sourced<T>> sourcedType, String sourcedName) {
            this.journal = journal;
            this.sourcedType = sourcedType;
            this.sourcedName = sourcedName;
            this.entryAdapterProvider = new EntryAdapterProvider();
            this.stateAdapterProvider = new StateAdapterProvider();
        }

        public EntryAdapterProvider entryAdapterProvider() {
            return this.entryAdapterProvider;
        }

        public StateAdapterProvider stateAdapterProvider() {
            return this.stateAdapterProvider;
        }

        public Journal<T> journal() {
            return this.journal;
        }

        public boolean isBinary() {
            return false;
        }

        public boolean isObject() {
            return false;
        }

        public boolean isText() {
            return false;
        }

        public <S extends Source<?>, E extends Entry<?>> Info<T> registerEntryAdapter(Class<S> sourceType, EntryAdapter<S, E> adapter) {
            this.entryAdapterProvider.registerAdapter(sourceType, adapter);
            return this;
        }

        public <S extends Source<?>, E extends Entry<?>> Info<T> registerEntryAdapter(Class<S> sourceType, EntryAdapter<S, E> adapter, BiConsumer<Class<S>, EntryAdapter<S, E>> consumer) {
            this.entryAdapterProvider.registerAdapter(sourceType, adapter, consumer);
            return this;
        }

        public <S, ST extends State<?>> Info<T> registerStateAdapter(Class<S> stateType, StateAdapter<S, ST> adapter) {
            this.stateAdapterProvider.registerAdapter(stateType, adapter);
            return this;
        }

        public <S, ST extends State<?>> Info<T> registerStateAdapter(Class<S> stateType, StateAdapter<S, ST> adapter, BiConsumer<Class<S>, StateAdapter<S, ST>> consumer) {
            this.stateAdapterProvider.registerAdapter(stateType, adapter, consumer);
            return this;
        }
    }
}

