/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.model.stateful;

import io.vlingo.actors.CompletesEventually;
import io.vlingo.actors.CompletionSupplier;
import io.vlingo.common.Completes;
import io.vlingo.common.Outcome;
import io.vlingo.common.Tuple3;
import io.vlingo.lattice.model.EntityActor;
import io.vlingo.lattice.model.stateful.StatefulTypeRegistry;
import io.vlingo.symbio.Metadata;
import io.vlingo.symbio.Source;
import io.vlingo.symbio.store.Result;
import io.vlingo.symbio.store.StorageException;
import io.vlingo.symbio.store.state.StateStore;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;

public abstract class StatefulEntity<S>
extends EntityActor
implements StateStore.ReadResultInterest,
StateStore.WriteResultInterest {
    protected final String id;
    private int currentVersion;
    private final StatefulTypeRegistry.Info<S> info;
    private final StateStore.ReadResultInterest readInterest;
    private final StateStore.WriteResultInterest writeInterest;

    protected StatefulEntity() {
        this(null);
    }

    protected StatefulEntity(String id) {
        this.id = id != null ? id : this.address().idString();
        this.currentVersion = 0;
        this.info = this.info();
        this.readInterest = (StateStore.ReadResultInterest)this.selfAs(StateStore.ReadResultInterest.class);
        this.writeInterest = (StateStore.WriteResultInterest)this.selfAs(StateStore.WriteResultInterest.class);
    }

    public void start() {
        super.start();
        Tuple3 newState = this.whenNewState();
        if (newState == null) {
            this.restore(true);
        } else {
            this.apply(newState._1, (List)newState._2, "", (String)newState._3, null);
        }
    }

    protected void afterApply() {
    }

    protected int currentVersion() {
        return this.currentVersion;
    }

    protected String idFrom(String separator, String ... idSegments) {
        StringBuilder builder = new StringBuilder();
        builder.append(idSegments[0]);
        for (int idx = 1; idx < idSegments.length; ++idx) {
            builder.append(separator).append(idSegments[idx]);
        }
        return builder.toString();
    }

    protected <C, RT> Completes<RT> apply(S state, List<Source<C>> sources, String metadataValue, String operation, Supplier<RT> andThen) {
        Metadata metadata = Metadata.with(state, (String)(metadataValue == null ? "" : metadataValue), (String)(operation == null ? "" : operation));
        this.stowMessages(new Class[]{StateStore.WriteResultInterest.class});
        this.info.store.write(this.id, state, this.nextVersion(), sources, metadata, this.writeInterest, (Object)CompletionSupplier.supplierOrNull(andThen, (CompletesEventually)this.completesEventually()));
        return andThen == null ? null : this.completes();
    }

    protected <RT> Completes<RT> apply(S state, String metadataValue, String operation, Supplier<RT> andThen) {
        Metadata metadata = Metadata.with(state, (String)(metadataValue == null ? "" : metadataValue), (String)(operation == null ? "" : operation));
        this.stowMessages(new Class[]{StateStore.WriteResultInterest.class});
        this.info.store.write(this.id, state, this.nextVersion(), metadata, this.writeInterest, (Object)CompletionSupplier.supplierOrNull(andThen, (CompletesEventually)this.completesEventually()));
        return andThen == null ? null : this.completes();
    }

    protected <C, RT> Completes<RT> apply(S state, List<Source<C>> sources, String operation, Supplier<RT> andThen) {
        return this.apply(state, "", operation, andThen);
    }

    protected <RT> Completes<RT> apply(S state, String operation, Supplier<RT> andThen) {
        return this.apply(state, "", operation, andThen);
    }

    protected <C, RT> Completes<RT> apply(S state, List<Source<C>> sources, Supplier<RT> andThen) {
        return this.apply(state, sources, "", "", andThen);
    }

    protected <RT> Completes<RT> apply(S state, Supplier<RT> andThen) {
        return this.apply(state, "", "", andThen);
    }

    protected <C> void apply(S state, List<Source<C>> sources, String metadataValue, String operation) {
        this.apply(state, sources, metadataValue, operation, null);
    }

    protected void apply(S state, String metadataValue, String operation) {
        this.apply(state, metadataValue, operation, null);
    }

    protected <C> void apply(S state, List<Source<C>> sources, String operation) {
        this.apply(state, "", operation, null);
    }

    protected void apply(S state, String operation) {
        this.apply(state, "", operation, null);
    }

    protected <C> void apply(S state, List<Source<C>> sources) {
        this.apply(state, sources, "", "", null);
    }

    protected <C, RT> Completes<RT> apply(S state, Source<C> source, Supplier<RT> andThen) {
        return this.apply(state, Arrays.asList(source), "", "", andThen);
    }

    protected <C> void apply(S state, Source<C> source) {
        this.apply(state, Arrays.asList(source), "", "", null);
    }

    protected void apply(S state) {
        this.apply(state, "", "", null);
    }

    protected <C> Tuple3<S, List<Source<C>>, String> whenNewState() {
        return null;
    }

    @Override
    protected final void restore() {
        this.restore(false);
    }

    protected abstract void state(S var1);

    protected abstract Class<S> stateType();

    public final <ST> void readResultedIn(Outcome<StorageException, Result> outcome, String id, ST state, int stateVersion, Metadata metadata, Object object) {
        outcome.andThen(result -> {
            this.state(state);
            this.currentVersion = stateVersion;
            this.disperseStowedMessages();
            return result;
        }).otherwise(cause -> {
            this.disperseStowedMessages();
            boolean ignoreNotFound = (Boolean)object;
            if (!ignoreNotFound) {
                String message = "State not restored for: " + ((Object)((Object)this)).getClass() + "(" + id + ") because: " + cause.result + " with: " + cause.getMessage();
                this.logger().error(message, (Throwable)cause);
                throw new IllegalStateException(message, (Throwable)cause);
            }
            return cause.result;
        });
    }

    public final <ST, C> void writeResultedIn(Outcome<StorageException, Result> outcome, String id, ST state, int stateVersion, List<Source<C>> sources, Object supplier) {
        outcome.andThen(result -> {
            this.state(state);
            this.currentVersion = stateVersion;
            this.afterApply();
            this.completeUsing(supplier);
            this.disperseStowedMessages();
            return result;
        }).otherwise(cause -> {
            this.disperseStowedMessages();
            String message = "State not applied for: " + ((Object)((Object)this)).getClass() + "(" + id + ") because: " + cause.result + " with: " + cause.getMessage();
            this.logger().error(message, (Throwable)cause);
            throw new IllegalStateException(message, (Throwable)cause);
        });
    }

    private void completeUsing(Object supplier) {
        if (supplier != null) {
            ((CompletionSupplier)supplier).complete();
        }
    }

    private StatefulTypeRegistry.Info<S> info() {
        try {
            return ((StatefulTypeRegistry)this.stage().world().resolveDynamic(StatefulTypeRegistry.INTERNAL_NAME, StatefulTypeRegistry.class)).info(this.stateType());
        }
        catch (Exception e) {
            String message = ((Object)((Object)this)).getClass().getSimpleName() + ": Info not registered with StatefulTypeRegistry.";
            this.logger().error(message);
            throw new IllegalStateException(message);
        }
    }

    private int nextVersion() {
        return this.currentVersion + 1;
    }

    private void restore(boolean ignoreNotFound) {
        this.stowMessages(new Class[]{StateStore.ReadResultInterest.class});
        this.info.store.read(this.id, this.info.storeType, this.readInterest, (Object)ignoreNotFound);
    }
}

