/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.model.stateful;

import io.vlingo.actors.World;
import io.vlingo.symbio.store.state.StateStore;
import io.vlingo.symbio.store.state.StateTypeStateStoreMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public final class StatefulTypeRegistry {
    static final String INTERNAL_NAME = UUID.randomUUID().toString();
    private final Map<Class<?>, Info<?>> stores = new HashMap();

    public static StatefulTypeRegistry registerAll(World world, StateStore stateStore, Class<?> ... types) {
        StatefulTypeRegistry registry = new StatefulTypeRegistry(world);
        for (Class<?> type : types) {
            registry.register(new Info(stateStore, type, type.getSimpleName()));
        }
        return registry;
    }

    public static StatefulTypeRegistry statefulTypeRegistry(World world) {
        return (StatefulTypeRegistry)world.resolveDynamic(INTERNAL_NAME, StatefulTypeRegistry.class);
    }

    public StatefulTypeRegistry(World world) {
        world.registerDynamic(INTERNAL_NAME, (Object)this);
    }

    public <S> Info<S> info(Class<?> type) {
        return this.stores.get(type);
    }

    public StatefulTypeRegistry register(Info<?> info) {
        StateTypeStateStoreMap.stateTypeToStoreName(info.storeType, (String)info.storeName);
        this.stores.put(info.storeType, info);
        return this;
    }

    public static class TextInfo<S>
    extends Info<S> {
        public TextInfo(StateStore store, Class<S> storeType, String storeName) {
            super(store, storeType, storeName);
        }

        @Override
        public boolean isText() {
            return true;
        }
    }

    public static class BinaryInfo<S>
    extends Info<S> {
        public BinaryInfo(StateStore store, Class<S> storeType, String storeName) {
            super(store, storeType, storeName);
        }

        @Override
        public boolean isBinary() {
            return true;
        }
    }

    public static class Info<S> {
        public final StateStore store;
        public final String storeName;
        public final Class<S> storeType;

        public Info(StateStore store, Class<S> storeType, String storeName) {
            this.store = store;
            this.storeType = storeType;
            this.storeName = storeName;
        }

        public boolean isBinary() {
            return false;
        }

        public boolean isText() {
            return false;
        }
    }
}

