/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.query;

import io.vlingo.actors.Actor;
import io.vlingo.actors.CompletesEventually;
import io.vlingo.actors.CompletionTranslator;
import io.vlingo.common.Completes;
import io.vlingo.common.Outcome;
import io.vlingo.lattice.query.ObjectQueryFailedException;
import io.vlingo.lattice.query.QueryAttempt;
import io.vlingo.symbio.store.QueryExpression;
import io.vlingo.symbio.store.Result;
import io.vlingo.symbio.store.StorageException;
import io.vlingo.symbio.store.object.ObjectStore;
import io.vlingo.symbio.store.object.ObjectStoreReader;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;

public abstract class StateObjectQueryActor
extends Actor
implements ObjectStoreReader.QueryResultInterest {
    private final ObjectStore objectStore;
    private final ObjectStoreReader.QueryResultInterest queryResultInterest;

    protected StateObjectQueryActor(ObjectStore objectStore) {
        this.objectStore = objectStore;
        this.queryResultInterest = (ObjectStoreReader.QueryResultInterest)this.selfAs(ObjectStoreReader.QueryResultInterest.class);
    }

    protected Optional<ObjectQueryFailedException> afterQueryFailed(ObjectQueryFailedException exception) {
        return Optional.of(exception);
    }

    protected <S, O, R> Completes<R> queryAll(Class<S> stateObjectType, QueryExpression query, Function<O, R> andThen) {
        this.objectStore.queryAll(query, this.queryResultInterest, QueryAttempt.with(QueryAttempt.Cardinality.All, stateObjectType, query, CompletionTranslator.translatorOrNull(andThen, (CompletesEventually)this.completesEventually())));
        return this.completes();
    }

    protected <S, O, R> Completes<R> queryObject(Class<S> stateObjectType, QueryExpression query, Function<O, R> andThen) {
        this.objectStore.queryObject(query, this.queryResultInterest, QueryAttempt.with(QueryAttempt.Cardinality.Object, stateObjectType, query, CompletionTranslator.translatorOrNull(andThen, (CompletesEventually)this.completesEventually())));
        return this.completes();
    }

    public final void queryAllResultedIn(Outcome<StorageException, Result> outcome, ObjectStoreReader.QueryMultiResults queryResults, Object attempt) {
        outcome.andThen(result -> {
            this.completeUsing(attempt, queryResults.stateObjects);
            return result;
        }).otherwise(cause -> {
            switch (cause.result) {
                case NotFound: {
                    this.completeUsing(attempt, Collections.emptyList());
                    return cause.result;
                }
            }
            String message = "Query failed because: " + cause.result + " with: " + cause.getMessage();
            ObjectQueryFailedException exception = new ObjectQueryFailedException(QueryAttempt.from(attempt), message, (Throwable)cause);
            Optional<ObjectQueryFailedException> maybeException = this.afterQueryFailed(exception);
            if (maybeException.isPresent()) {
                this.logger().error(message, (Throwable)maybeException.get());
                throw maybeException.get();
            }
            this.logger().error(message, (Throwable)exception);
            return cause.result;
        });
    }

    public final void queryObjectResultedIn(Outcome<StorageException, Result> outcome, ObjectStoreReader.QuerySingleResult queryResult, Object attempt) {
        outcome.andThen(result -> {
            this.completeUsing(attempt, queryResult.stateObject);
            return result;
        }).otherwise(cause -> {
            switch (cause.result) {
                case NotFound: {
                    this.completeUsing(attempt, queryResult.stateObject);
                    return cause.result;
                }
            }
            String message = "Query failed because: " + cause.result + " with: " + cause.getMessage();
            ObjectQueryFailedException exception = new ObjectQueryFailedException(QueryAttempt.from(attempt), message, (Throwable)cause);
            Optional<ObjectQueryFailedException> maybeException = this.afterQueryFailed(exception);
            if (maybeException.isPresent()) {
                this.logger().error(message, (Throwable)maybeException.get());
                throw maybeException.get();
            }
            this.logger().error(message, (Throwable)exception);
            return cause.result;
        });
    }

    private <O> void completeUsing(Object attempt, O outcome) {
        if (attempt != null) {
            QueryAttempt.from((Object)attempt).completionTranslator.complete(outcome);
        }
    }
}

