/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.query;

import io.vlingo.actors.Actor;
import io.vlingo.actors.CompletesEventually;
import io.vlingo.common.Completes;
import io.vlingo.common.Outcome;
import io.vlingo.lattice.CompositeIdentitySupport;
import io.vlingo.reactivestreams.Sink;
import io.vlingo.reactivestreams.sink.TerminalOperationConsumerSink;
import io.vlingo.symbio.Metadata;
import io.vlingo.symbio.State;
import io.vlingo.symbio.StateBundle;
import io.vlingo.symbio.store.Result;
import io.vlingo.symbio.store.StorageException;
import io.vlingo.symbio.store.state.StateStore;
import java.util.Collection;
import java.util.function.Consumer;

public abstract class StateStoreQueryActor
extends Actor
implements CompositeIdentitySupport,
StateStore.ReadResultInterest {
    private final StateStore.ReadResultInterest readInterest;
    private final StateStore stateStore;

    protected StateStoreQueryActor(StateStore stateStore) {
        this.stateStore = stateStore;
        this.readInterest = (StateStore.ReadResultInterest)this.selfAs(StateStore.ReadResultInterest.class);
    }

    protected <T> Completes<State.ObjectState<T>> queryObjectStateFor(String id, Class<T> type) {
        return this.queryFor(id, type, QueryResultHandler.ResultType.ObjectState, State.ObjectState.Null);
    }

    protected <T> Completes<State.ObjectState<T>> queryObjectStateFor(String id, Class<T> type, State.ObjectState<T> notFoundState) {
        return this.queryFor(id, type, QueryResultHandler.ResultType.ObjectState, notFoundState);
    }

    protected <T, R> Completes<Collection<R>> streamAllOf(Class<T> type, Collection<R> all) {
        return this.queryAllOf(type, all);
    }

    protected <T> Completes<T> queryStateFor(String id, Class<T> type) {
        return this.queryFor(id, type, QueryResultHandler.ResultType.Unwrapped, null);
    }

    protected <T> Completes<T> queryStateFor(String id, Class<T> type, T notFoundState) {
        return this.queryFor(id, type, QueryResultHandler.ResultType.Unwrapped, notFoundState);
    }

    private <T, R> Completes<Collection<R>> queryAllOf(Class<T> type, Collection<R> all) {
        Consumer<StateBundle> populator = state -> all.add(state.object);
        CompletesEventually completes = this.completesEventually();
        Consumer<Collection> collector = collected -> completes.with(collected);
        TerminalOperationConsumerSink sink = new TerminalOperationConsumerSink(populator, all, collector);
        this.stateStore.streamAllOf(type).andFinallyConsume(stream -> stream.flowInto((Sink)sink));
        return this.completes();
    }

    private <T> Completes<T> queryFor(String id, Class<T> type, QueryResultHandler.ResultType resultType, T notFoundState) {
        CompletesEventually completes = this.completesEventually();
        Consumer<Object> answer = maybeFoundState -> completes.with(maybeFoundState);
        this.stateStore.read(id, type, this.readInterest, new QueryResultHandler<Object>(answer, resultType, notFoundState));
        return this.completes();
    }

    public final <S> void readResultedIn(Outcome<StorageException, Result> outcome, String id, S state, int stateVersion, Metadata metadata, Object object) {
        outcome.andThen(result -> {
            QueryResultHandler.from(object).completeFoundWith(id, state, stateVersion, metadata);
            return result;
        }).otherwise(cause -> {
            if (cause.result.isNotFound()) {
                QueryResultHandler.from(object).completeNotFound();
            } else {
                this.logger().info("Query state not read for update because: " + cause.getMessage(), (Throwable)cause);
            }
            return cause.result;
        });
    }

    private static final class QueryResultHandler<T> {
        final Consumer<T> consumer;
        final T notFoundState;
        final ResultType resultType;

        static QueryResultHandler from(Object handler) {
            return (QueryResultHandler)handler;
        }

        QueryResultHandler(Consumer<T> consumer, ResultType resultType, T notFoundState) {
            this.consumer = consumer;
            this.resultType = resultType;
            this.notFoundState = notFoundState;
        }

        void completeNotFound() {
            this.consumer.accept(this.notFoundState);
        }

        void completeFoundWith(String id, T state, int stateVersion, Metadata metadata) {
            switch (this.resultType) {
                case ObjectState: {
                    this.consumer.accept(new State.ObjectState(id, Object.class, 1, state, stateVersion, metadata));
                    break;
                }
                case Unwrapped: {
                    this.consumer.accept(state);
                }
            }
        }

        private static enum ResultType {
            ObjectState,
            Unwrapped;

        }
    }
}

