/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.router;

import io.vlingo.actors.Stage;
import io.vlingo.lattice.model.Command;
import io.vlingo.lattice.router.LoadBalancingCommandRouter;
import io.vlingo.lattice.router.PartitioningCommandRouter;
import io.vlingo.lattice.router.RoundRobinCommandRouter;
import io.vlingo.lattice.router.RoutableCommand;

public interface CommandRouter {
    public static CommandRouter of(Stage stage, Type type, int totalRoutees) {
        switch (type) {
            case LoadBalancing: {
                return (CommandRouter)stage.actorFor(CommandRouter.class, LoadBalancingCommandRouter.class, new Object[]{totalRoutees});
            }
            case Partitioning: {
                return (CommandRouter)stage.actorFor(CommandRouter.class, PartitioningCommandRouter.class, new Object[]{totalRoutees});
            }
            case RoundRobin: {
                return (CommandRouter)stage.actorFor(CommandRouter.class, RoundRobinCommandRouter.class, new Object[]{totalRoutees});
            }
        }
        throw new IllegalArgumentException("The command router type is not mapped: " + (Object)((Object)type));
    }

    public <P, C extends Command, A> void route(RoutableCommand<P, C, A> var1);

    public static enum Type {
        LoadBalancing,
        Partitioning,
        RoundRobin;

    }
}

