/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.router;

import io.vlingo.actors.ContentBasedRouter;
import io.vlingo.actors.Definition;
import io.vlingo.actors.Routee;
import io.vlingo.actors.RouterSpecification;
import io.vlingo.actors.Routing;
import io.vlingo.lattice.model.Command;
import io.vlingo.lattice.router.CommandRouter;
import io.vlingo.lattice.router.CommandRouterWorkerActor;
import io.vlingo.lattice.router.RoutableCommand;
import java.util.List;

public class PartitioningCommandRouter
extends ContentBasedRouter<CommandRouter>
implements CommandRouter {
    private Routee<CommandRouter> currentRoutee;
    private final int totalRoutees;

    public PartitioningCommandRouter(int totalRoutees) {
        super(new RouterSpecification(totalRoutees, Definition.has(CommandRouterWorkerActor.class, (List)Definition.NoParameters), CommandRouter.class));
        this.totalRoutees = totalRoutees;
    }

    @Override
    public <P, C extends Command, A> void route(RoutableCommand<P, C, A> command) {
        int partition = command.hashCode() % this.totalRoutees;
        this.currentRoutee = this.routeeAt(partition);
        this.dispatchCommand(CommandRouter::route, command);
    }

    protected Routing<CommandRouter> computeRouting() {
        return Routing.with(this.currentRoutee);
    }
}

