/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.router;

import io.vlingo.actors.Actor;
import io.vlingo.actors.Address;
import io.vlingo.actors.Definition;
import io.vlingo.actors.Stage;
import io.vlingo.common.Completes;
import io.vlingo.lattice.model.Command;
import io.vlingo.lattice.router.CommandDispatcher;
import java.time.Duration;
import java.util.List;

public class RoutableCommand<P, C extends Command, A>
extends Command {
    private Class<? extends Actor> actorType;
    private String address;
    private String name = "";
    private Completes<A> answer;
    private C command;
    private CommandDispatcher<P, C, Completes<A>> handler;
    private Class<P> protocol;
    private long timeout = -1L;

    public static <P, C extends Command, A> RoutableCommand<P, C, A> speaks(Class<P> protocol) {
        assert (protocol != null);
        return new RoutableCommand<P, C, A>(protocol);
    }

    public RoutableCommand<P, C, A> to(Class<? extends Actor> actorType) {
        assert (actorType != null);
        this.actorType = actorType;
        return this;
    }

    public RoutableCommand<P, C, A> at(long address) {
        assert (address != -1L);
        this.address = String.valueOf(address);
        return this;
    }

    public RoutableCommand<P, C, A> at(String address) {
        assert (address != null);
        this.address = address;
        return this;
    }

    public RoutableCommand<P, C, A> named(String name) {
        assert (name != null);
        this.name = name;
        return this;
    }

    public RoutableCommand<P, C, A> delivers(C command) {
        assert (command != null);
        this.command = command;
        return this;
    }

    public RoutableCommand<P, C, A> timeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public RoutableCommand<P, C, A> timeout(Duration timeout) {
        return this.timeout(timeout.toMillis());
    }

    public C command() {
        return this.command;
    }

    public RoutableCommand copy() {
        return new RoutableCommand<P, C, A>(this.protocol, this.actorType, this.address, this.command, this.answer, this.handler);
    }

    public String id() {
        return this.command == null || this.command.id().isEmpty() ? super.id() : this.command.id();
    }

    public <PROTOCOL, COMMAND extends Command, ANSWER> RoutableCommand<PROTOCOL, COMMAND, ANSWER> answers(Completes<ANSWER> answer) {
        assert (answer != null);
        this.answer = answer;
        return this;
    }

    public Completes<A> answer() {
        return this.answer;
    }

    public <PROTOCOL, COMMAND extends Command, ANSWER> RoutableCommand<PROTOCOL, COMMAND, ANSWER> handledBy(CommandDispatcher handler) {
        assert (handler != null);
        this.handler = handler;
        return this;
    }

    public void handleWithin(Stage stage) {
        this.check();
        Address actorAddress = stage.addressFactory().from(this.address, this.name);
        stage.actorOf(this.protocol, actorAddress).andThenConsume(this.timeout, actor -> this.handler.accept(actor, this.command, this.answer)).otherwise(noActor -> {
            Object actor = stage.actorFor(this.protocol, Definition.has(this.actorType, (List)Definition.NoParameters, (String)this.name), actorAddress);
            this.handler.accept(actor, this.command, this.answer);
            return actor;
        });
    }

    protected RoutableCommand(Class<P> protocol) {
        this.protocol = protocol;
    }

    protected RoutableCommand(Class<P> protocol, Class<? extends Actor> actorType, String address, C command, Completes<A> answer, CommandDispatcher handler) {
        this.protocol = protocol;
        this.actorType = actorType;
        this.address = address;
        this.command = command;
        this.answer = answer;
        this.handler = handler;
    }

    private void check() {
        assert (this.protocol != null);
        assert (this.actorType != null);
        assert (this.address != null);
        assert (this.command != null);
        assert (this.handler != null);
    }
}

