/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.util;

import io.vlingo.actors.Actor;
import io.vlingo.common.Scheduled;
import io.vlingo.lattice.util.HardRefHolder;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpiringHardRefHolder
extends Actor
implements HardRefHolder,
Scheduled<Object> {
    private static final Logger logger = LoggerFactory.getLogger(ExpiringHardRefHolder.class);
    private final Supplier<Instant> now;
    private final Duration timeout;
    private final PriorityQueue<Expiring> queue;

    public ExpiringHardRefHolder() {
        this(Duration.ofSeconds(20L));
    }

    public ExpiringHardRefHolder(Duration timeout) {
        this(timeout, 1000);
    }

    public ExpiringHardRefHolder(Duration timeout, int initialCapacity) {
        this(Instant::now, timeout, initialCapacity);
    }

    ExpiringHardRefHolder(Supplier<Instant> now, Duration timeout, int initialCapacity) {
        this.now = now;
        this.timeout = timeout;
        this.queue = new PriorityQueue(initialCapacity);
        this.scheduler().schedule((Scheduled)this.selfAs(Scheduled.class), null, 0L, 1000L);
    }

    @Override
    public void holdOnTo(Object object) {
        Instant expiry = this.now.get().plus(this.timeout);
        logger.debug("Holding on to {} until {}", object, (Object)expiry);
        this.queue.offer(new Expiring(expiry, object));
    }

    public void intervalSignal(Scheduled<Object> scheduled, Object data) {
        Expiring next;
        logger.debug("Starting expired references cleanup at {} ...", (Object)this.now.get());
        int count = 0;
        while ((next = this.queue.peek()) != null) {
            if (next.bestBefore.isBefore(this.now.get())) {
                this.queue.remove();
                ++count;
            } else {
                next = null;
            }
            if (next != null) continue;
        }
        logger.debug("Finished cleanup of expired references at {}. {} removed.", (Object)this.now.get(), (Object)count);
    }

    private static class Expiring
    implements Comparable<Expiring> {
        final Instant bestBefore;
        final Object reference;

        private Expiring(Instant bestBefore, Object reference) {
            Objects.requireNonNull(bestBefore);
            this.bestBefore = bestBefore;
            Objects.requireNonNull(reference);
            this.reference = reference;
        }

        @Override
        public int compareTo(Expiring o) {
            if (Objects.isNull(o)) {
                return 1;
            }
            return this.bestBefore.compareTo(o.bestBefore);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Expiring expiring = (Expiring)o;
            return this.bestBefore.equals(expiring.bestBefore) && this.reference.equals(expiring.reference);
        }

        public int hashCode() {
            return Objects.hash(this.bestBefore, this.reference);
        }

        public String toString() {
            return "Expiring(bestBefore=" + this.bestBefore + ", reference=" + this.reference + ')';
        }
    }
}

