/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.util;

import io.vlingo.lattice.util.HardRefHolder;
import io.vlingo.lattice.util.WeakQueue;
import io.vlingo.wire.node.Id;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public final class OutBuffers {
    private static Queue<Runnable> EMPTY = new LinkedList<Runnable>();
    private final Supplier<Queue<Runnable>> queueInitializer;
    private final Map<Id, Queue<Runnable>> buffers;
    private final HardRefHolder holder;

    public OutBuffers(HardRefHolder holder) {
        this(WeakQueue::new, holder);
    }

    public OutBuffers(Supplier<Queue<Runnable>> queueInitializer, HardRefHolder holder) {
        this(queueInitializer, holder, 5, 0.85f);
    }

    public OutBuffers(Supplier<Queue<Runnable>> queueInitializer, HardRefHolder holder, int size, float loadFactor) {
        this.queueInitializer = queueInitializer;
        this.holder = holder;
        this.buffers = new ConcurrentHashMap<Id, Queue<Runnable>>(size, loadFactor);
    }

    public void enqueue(Id id, Runnable task) {
        if (!this.buffers.containsKey(id)) {
            this.buffers.putIfAbsent(id, this.queueInitializer.get());
        }
        if (Objects.nonNull(this.holder)) {
            this.holder.holdOnTo(task);
        }
        this.buffers.get(id).offer(task);
    }

    public Queue<Runnable> queue(Id id) {
        return this.buffers.getOrDefault(id, EMPTY);
    }
}

