/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.lattice.util;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class WeakQueue<T>
implements Queue<T> {
    private final AtomicBoolean idle = new AtomicBoolean(true);
    private Queue<WeakReference<T>> delegate;

    public WeakQueue() {
        this(new LinkedList<WeakReference<T>>());
    }

    private WeakQueue(Queue<WeakReference<T>> delegate) {
        this.delegate = delegate;
    }

    private Queue<WeakReference<T>> getDelegate() {
        this.expungeStaleEntries();
        return this.delegate;
    }

    private void expungeStaleEntries() {
        this.delegate.removeIf(weak -> Objects.isNull(weak.get()));
    }

    private <A> A atomic(Supplier<A> supplier) {
        try {
            while (this.idle.compareAndSet(true, false)) {
            }
            A a = supplier.get();
            return a;
        }
        finally {
            this.idle.set(true);
        }
    }

    private T expungeStaleEntryOnSupply(Supplier<WeakReference<T>> supplier) {
        return Optional.ofNullable(supplier.get()).map(w -> Optional.ofNullable(w.get()).orElseGet(() -> this.lambda$null$1((Supplier)supplier))).orElse(null);
    }

    @Override
    public boolean add(T t) {
        Objects.requireNonNull(t, "Null entries not allowed");
        return this.atomic(() -> this.getDelegate().add(new WeakReference<Object>(t)));
    }

    @Override
    public boolean offer(T t) {
        Objects.requireNonNull(t, "Null entries not allowed");
        return this.atomic(() -> this.getDelegate().offer(new WeakReference<Object>(t)));
    }

    @Override
    public T remove() {
        return (T)this.atomic(() -> this.expungeStaleEntryOnSupply(this.getDelegate()::remove));
    }

    @Override
    public T poll() {
        return (T)this.atomic(() -> this.expungeStaleEntryOnSupply(this.delegate::poll));
    }

    @Override
    public T element() {
        return (T)this.atomic(() -> this.expungeStaleEntryOnSupply(this.delegate::element));
    }

    @Override
    public T peek() {
        return (T)this.atomic(() -> this.expungeStaleEntryOnSupply(this.getDelegate()::peek));
    }

    @Override
    public int size() {
        return this.atomic(() -> this.getDelegate().size());
    }

    @Override
    public boolean isEmpty() {
        return this.atomic(() -> this.getDelegate().isEmpty());
    }

    @Override
    public boolean contains(Object o) {
        return this.atomic(() -> this.getDelegate().stream().map(Reference::get).anyMatch(e -> Objects.nonNull(e) && e.equals(o)));
    }

    @Override
    public Iterator<T> iterator() {
        return new ExpungingIterator(this.delegate.iterator());
    }

    @Override
    public Object[] toArray() {
        return this.atomic(() -> this.getDelegate().stream().map(Reference::get).filter(Objects::nonNull).toArray());
    }

    @Override
    public <A> A[] toArray(A[] a) {
        return this.atomic(() -> this.getDelegate().stream().map(Reference::get).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new)).toArray(a));
    }

    @Override
    public boolean remove(Object o) {
        return this.atomic(() -> {
            this.delegate = this.getDelegate().stream().filter(w -> !o.equals(w.get())).collect(Collectors.toCollection(LinkedList::new));
            return this.delegate.remove(o);
        });
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        c.forEach(Objects::requireNonNull);
        return this.atomic(() -> this.getDelegate().addAll(c.stream().map(t -> new WeakReference<Object>(t)).collect(Collectors.toCollection(ArrayList::new))));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.delegate.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(c);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    private /* synthetic */ Object lambda$null$1(Supplier supplier) {
        return this.expungeStaleEntryOnSupply(supplier);
    }

    private class ExpungingIterator
    implements Iterator<T> {
        private final Iterator<WeakReference<T>> iterator;
        private T next;

        private ExpungingIterator(Iterator<WeakReference<T>> iterator) {
            this.iterator = iterator;
        }

        private WeakReference<T> iterate() {
            if (this.iterator.hasNext()) {
                return this.iterator.next();
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            this.next = WeakQueue.this.expungeStaleEntryOnSupply(this::iterate);
            return this.next != null;
        }

        @Override
        public T next() {
            return this.next;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

