/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.reactivestreams;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Elements<T> {
    private static final Object[] Empty = new Object[0];
    public final T[] values;
    public final boolean terminated;

    public static final <T> Elements<T> empty() {
        return new Elements<Object>(Empty, false);
    }

    public static final <T> Elements<T> of(T value) {
        return new Elements<Object>(new Object[]{value}, false);
    }

    public static final <T> Elements<T> of(T ... values) {
        return new Elements<T>(values, false);
    }

    public static final <T> Elements<T> terminated() {
        return new Elements<Object>(Empty, true);
    }

    public Elements(T[] values, boolean terminated) {
        this.values = values;
        this.terminated = terminated;
    }

    public T elementAt(int index) {
        if (this.values.length == 0) {
            return null;
        }
        return this.values[index];
    }

    public boolean hasElementAt(int index) {
        if (this.values.length == 0) {
            return false;
        }
        return index < this.values.length;
    }

    public String elementsAsString() {
        return Arrays.asList(this.values).toString();
    }

    public List<T> asList() {
        return Collections.unmodifiableList(Arrays.asList(this.values));
    }

    public int size() {
        return this.values.length;
    }

    public String toString() {
        return "Elements[values=" + this.elementsAsString() + " terminated=" + this.terminated + "]";
    }
}

