/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.reactivestreams;

import io.vlingo.reactivestreams.Streams;

public class PublisherConfiguration {
    public static int DefaultProbeInterval = 5;
    public static int FastProbeInterval = 2;
    public static int FastestProbeInterval = 1;
    public final int bufferSize;
    public final int maxThrottle;
    public final Streams.OverflowPolicy overflowPolicy;
    public final int probeInterval;

    public static PublisherConfiguration defaultDropCurrent() {
        return new PublisherConfiguration(DefaultProbeInterval, -1, 256, Streams.OverflowPolicy.DropCurrent);
    }

    public static PublisherConfiguration defaultDropHead() {
        return new PublisherConfiguration(DefaultProbeInterval, -1, 256, Streams.OverflowPolicy.DropHead);
    }

    public static PublisherConfiguration defaultDropTail() {
        return new PublisherConfiguration(DefaultProbeInterval, -1, 256, Streams.OverflowPolicy.DropTail);
    }

    public static PublisherConfiguration with(int probeInterval, int maxThrottle, int bufferSize, Streams.OverflowPolicy overflowPolicy) {
        return new PublisherConfiguration(probeInterval, maxThrottle, bufferSize, overflowPolicy);
    }

    public PublisherConfiguration(int probeInterval, int maxThrottle, int bufferSize, Streams.OverflowPolicy overflowPolicy) {
        assert (probeInterval > 0);
        this.probeInterval = probeInterval;
        assert (maxThrottle == -1 || maxThrottle > 0);
        this.maxThrottle = maxThrottle;
        assert (bufferSize > 0);
        this.bufferSize = bufferSize;
        assert (overflowPolicy != null);
        this.overflowPolicy = overflowPolicy;
    }

    public PublisherConfiguration(int probeInterval, Streams.OverflowPolicy overflowPolicy) {
        this(probeInterval, -1, 256, overflowPolicy);
    }
}

