/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.reactivestreams;

import io.vlingo.reactivestreams.sink.ConsumerSink;
import io.vlingo.reactivestreams.sink.PrintSink;
import java.io.PrintStream;
import java.util.function.Consumer;

public interface Sink<T> {
    public static <T> Sink<T> consumeWith(Consumer<T> consumer) {
        return new ConsumerSink<T>(consumer);
    }

    public static <T> Sink<T> printToStdout(String prefix) {
        return Sink.printTo(System.out, prefix);
    }

    public static <T> Sink<T> printToStderr(String prefix) {
        return Sink.printTo(System.err, prefix);
    }

    public static <T> Sink<T> printTo(PrintStream printStream, String prefix) {
        return new PrintSink(printStream, prefix);
    }

    public void ready();

    public void terminate();

    public void whenValue(T var1);
}

