/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.reactivestreams;

import io.vlingo.common.Completes;
import io.vlingo.reactivestreams.Elements;
import io.vlingo.reactivestreams.source.IterableSource;
import io.vlingo.reactivestreams.source.LongRangeSource;
import io.vlingo.reactivestreams.source.SupplierSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;

public interface Source<T> {
    public static <T> Source<T> empty() {
        return new IterableSource(new ArrayList(0), false);
    }

    @SafeVarargs
    public static <T> Source<T> only(T ... elements) {
        return new IterableSource<T>(Arrays.asList(elements), false);
    }

    public static Source<Long> rangeOf(long startInclusive, long endExclusive) {
        return new LongRangeSource(startInclusive, endExclusive);
    }

    public static long orElseMaximum(long elements) {
        if (elements < 0L) {
            return Long.MAX_VALUE;
        }
        return elements;
    }

    public static long orElseMinimum(long elements) {
        if (elements < 0L) {
            return 0L;
        }
        return elements;
    }

    public static <T> Source<T> with(Iterable<T> iterable) {
        return Source.with(iterable, false);
    }

    public static <T> Source<T> with(Iterable<T> iterable, boolean slowIterable) {
        return new IterableSource<T>(iterable, slowIterable);
    }

    public static <T> Source<T> with(Supplier<T> supplier) {
        return Source.with(supplier, false);
    }

    public static <T> Source<T> with(Supplier<T> supplier, boolean slowSupplier) {
        return new SupplierSource<T>(supplier, slowSupplier);
    }

    public Completes<Elements<T>> next();

    public Completes<Elements<T>> next(int var1);

    public Completes<Elements<T>> next(long var1);

    public Completes<Elements<T>> next(long var1, int var3);

    public Completes<Boolean> isSlow();
}

