/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.reactivestreams;

import io.vlingo.actors.Logger;
import io.vlingo.actors.Stage;
import io.vlingo.reactivestreams.PublisherConfiguration;
import io.vlingo.reactivestreams.Sink;
import io.vlingo.reactivestreams.Source;
import io.vlingo.reactivestreams.StreamPublisher;
import io.vlingo.reactivestreams.StreamSubscriber;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class Streams {
    private static Logger logger;
    public static final int DefaultBufferSize = 256;
    public static final int DefaultMaxThrottle = -1;

    public static void logger(Logger logger) {
        if (Streams.logger != null) {
            throw new IllegalStateException("Logger is already set.");
        }
        Streams.logger = logger;
    }

    public static Logger logger() {
        if (logger == null) {
            throw new NullPointerException("Logger is null.");
        }
        return logger;
    }

    static <T, S> Publisher<T> publisherWith(Stage stage, Source<S> source) {
        return Streams.publisherWith(stage, source, PublisherConfiguration.defaultDropHead());
    }

    static <T, S> Publisher<T> publisherWith(Stage stage, Source<S> source, PublisherConfiguration configuration) {
        return (Publisher)stage.actorFor(Publisher.class, StreamPublisher.class, new Object[]{source, configuration});
    }

    static <T, S> Subscriber<T> subscriberWith(Stage stage, Sink<S> sink) {
        return Streams.subscriberWith(stage, sink, Long.MAX_VALUE);
    }

    static <T, S> Subscriber<T> subscriberWith(Stage stage, Sink<S> sink, long requestThreshold) {
        return (Subscriber)stage.actorFor(Subscriber.class, StreamSubscriber.class, new Object[]{sink, requestThreshold});
    }

    public static enum OverflowPolicy {
        DropHead,
        DropTail,
        DropCurrent;

    }
}

