/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.reactivestreams;

import io.vlingo.reactivestreams.ControlledSubscription;
import io.vlingo.reactivestreams.PublisherConfiguration;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class SubscriptionController<T>
implements Subscription {
    static final AtomicInteger nextId = new AtomicInteger(0);
    private final Queue<T> buffer;
    private final PublisherConfiguration configuration;
    private final int id;
    private int dropIndex;
    private final Subscriber<? super T> subscriber;
    private final ControlledSubscription<T> subscription;
    private boolean cancelled;
    private long count;
    private long maximum;

    SubscriptionController(Subscriber<? super T> subscriber, ControlledSubscription<T> subscription, PublisherConfiguration configuration) {
        this.subscriber = subscriber;
        this.subscription = subscription;
        this.configuration = configuration;
        this.id = nextId.incrementAndGet();
        this.buffer = new ArrayDeque<T>();
        this.cancelled = false;
    }

    public void cancel() {
        this.subscription.cancel(this);
    }

    public void request(long maximum) {
        if (maximum <= 0L) {
            IllegalArgumentException e = new IllegalArgumentException("Must be >= 1 and <= Long.MAX_VALUE");
            this.subscriber.onError((Throwable)e);
            return;
        }
        this.subscription.request(this, maximum);
    }

    public int hashCode() {
        return 31 * Integer.hashCode(this.id);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return this.id == ((SubscriptionController)other).id;
    }

    public String toString() {
        return "SubscriptionController [id=" + this.id + " count=" + this.count + " maximum=" + this.maximum + " remaining=" + this.remaining() + " unbounded=" + this.unbounded() + "]";
    }

    int id() {
        return this.id;
    }

    final Subscriber<? super T> subscriber() {
        return this.subscriber;
    }

    boolean hasBufferedElements() {
        return !this.buffer.isEmpty();
    }

    void onNext(T element) {
        if (this.remaining() > 0L) {
            this.sendNext(element);
        } else {
            if (element == null) {
                return;
            }
            if (this.buffer.size() < this.configuration.bufferSize) {
                this.buffer.add(element);
            } else {
                switch (this.configuration.overflowPolicy) {
                    case DropHead: {
                        this.dropHeadFor(element);
                        break;
                    }
                    case DropTail: {
                        this.dropTailFor(element);
                        break;
                    }
                }
            }
        }
    }

    void onError(Throwable cause) {
        this.subscriber.onError(cause);
    }

    private void dropHeadFor(T element) {
        this.buffer.poll();
        this.buffer.add(element);
    }

    private void dropTailFor(T element) {
        this.dropIndex = 0;
        int lastElement = this.buffer.size() - 1;
        this.buffer.removeIf(e -> this.dropIndex++ == lastElement);
        this.buffer.add(element);
    }

    private void sendNext(T element) {
        T next;
        long throttleCount = this.throttleCount();
        T currentElement = element;
        while (throttleCount-- > 0L && (next = this.swapBufferedOrElse(currentElement)) != null) {
            currentElement = null;
            this.subscriber.onNext(next);
            this.increment();
        }
    }

    private T swapBufferedOrElse(T element) {
        if (this.buffer.isEmpty()) {
            return element;
        }
        T next = this.buffer.poll();
        if (element != null) {
            this.buffer.add(element);
        }
        return next;
    }

    long accumulate(long amount) {
        if (this.maximum < Long.MAX_VALUE) {
            long accumulated = this.maximum + amount;
            if (accumulated < 0L) {
                accumulated = Long.MAX_VALUE;
            }
            return accumulated;
        }
        return this.maximum;
    }

    void cancelSubscription() {
        this.cancelled = true;
        this.count = 0L;
        this.maximum = 0L;
    }

    void increment() {
        if (this.count < this.maximum) {
            ++this.count;
        }
    }

    long maximum() {
        return this.maximum;
    }

    long remaining() {
        if (this.cancelled) {
            return 0L;
        }
        return this.maximum - this.count;
    }

    void requestFlow(long maximum) {
        this.maximum = maximum;
    }

    long throttleCount() {
        return this.configuration.maxThrottle == -1 ? this.remaining() : Math.min((long)this.configuration.maxThrottle, this.remaining());
    }

    boolean unbounded() {
        return this.maximum == Long.MAX_VALUE;
    }
}

