/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.reactivestreams.operator;

import io.vlingo.reactivestreams.Operator;
import io.vlingo.reactivestreams.Streams;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class Filter<T>
implements Operator<T, T> {
    private final Predicate<T> predicate;

    public Filter(Predicate<T> predicate) {
        this.predicate = predicate;
    }

    @Override
    public void performInto(T value, Consumer<T> consumer) {
        try {
            if (this.predicate.test(value)) {
                consumer.accept(value);
            }
        }
        catch (Exception e) {
            Streams.logger().error("Filter failed because: " + e.getMessage(), (Throwable)e);
        }
    }
}

