/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.reactivestreams.operator;

import io.vlingo.common.Completes;
import io.vlingo.reactivestreams.Elements;
import io.vlingo.reactivestreams.Source;
import java.util.ArrayDeque;
import java.util.Queue;

public abstract class QueueSource<R>
implements Source<R> {
    private final Queue<R> queue;
    private final boolean slow;
    private boolean terminated;

    protected QueueSource(boolean slow) {
        this.slow = slow;
        this.queue = new ArrayDeque<R>(1);
        this.terminated = false;
    }

    @Override
    public Completes<Elements<R>> next() {
        return this.next(0L, 1);
    }

    @Override
    public Completes<Elements<R>> next(int maximumElements) {
        return this.next(0L, maximumElements);
    }

    @Override
    public Completes<Elements<R>> next(long index) {
        return this.next(0L, 1);
    }

    @Override
    public Completes<Elements<R>> next(long index, int maximumElements) {
        if (!this.queue.isEmpty()) {
            int total = Math.min(this.queue.size(), maximumElements);
            Object[] elements = new Object[total];
            for (int idx = 0; idx < total; ++idx) {
                elements[idx] = this.queue.poll();
            }
            return Completes.withSuccess(Elements.of(elements));
        }
        return Completes.withSuccess(this.terminated ? Elements.terminated() : Elements.empty());
    }

    @Override
    public Completes<Boolean> isSlow() {
        return Completes.withSuccess((Object)this.slow);
    }

    protected void add(R value) {
        this.queue.add(value);
    }

    protected void terminated() {
        this.terminated = true;
    }

    protected boolean isTerminated() {
        return this.terminated;
    }
}

