/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.reactivestreams.sink;

import io.vlingo.reactivestreams.Sink;
import java.util.function.Consumer;

public class ConsumerSink<T>
implements Sink<T> {
    private final Consumer<T> consumer;
    private boolean terminated;

    public ConsumerSink(Consumer<T> consumer) {
        this.consumer = consumer;
        this.terminated = false;
    }

    @Override
    public void ready() {
    }

    @Override
    public void terminate() {
        this.terminated = true;
    }

    @Override
    public void whenValue(T value) {
        if (!this.terminated) {
            this.consumer.accept(value);
        }
    }

    public String toString() {
        return "ConsumerSink[terminated=" + this.terminated + "]";
    }
}

