/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.reactivestreams.sink;

import io.vlingo.reactivestreams.Sink;
import java.io.PrintStream;

public class PrintSink<T>
implements Sink<T> {
    private final PrintStream printStream;
    private final String prefix;
    private boolean terminated;

    public PrintSink(PrintStream printStream, String prefix) {
        this.printStream = printStream;
        this.prefix = prefix;
        this.terminated = false;
    }

    @Override
    public void ready() {
    }

    @Override
    public void terminate() {
        this.terminated = true;
    }

    @Override
    public void whenValue(T value) {
        if (!this.terminated) {
            this.printStream.println(this.prefix + value.toString());
        }
    }

    public String toString() {
        return "PrintSink[terminated=" + this.terminated + "]";
    }
}

