/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.reactivestreams.sink.test;

import io.vlingo.actors.testkit.AccessSafely;
import io.vlingo.reactivestreams.Sink;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class SafeConsumerSink<T>
implements Sink<T>,
Consumer<T> {
    private AccessSafely access = this.afterCompleting(0);
    private AtomicInteger readyCount = new AtomicInteger(0);
    private AtomicInteger terminateCount = new AtomicInteger(0);
    private AtomicInteger valueCount = new AtomicInteger(0);
    private final List<T> values = new CopyOnWriteArrayList<T>();

    @Override
    public void accept(T value) {
        this.whenValue(value);
    }

    @Override
    public void ready() {
        this.access.writeUsing("ready", (Object)1);
    }

    @Override
    public void terminate() {
        this.access.writeUsing("terminate", (Object)1);
    }

    @Override
    public void whenValue(T value) {
        this.access.writeUsing("value", (Object)1);
        this.access.writeUsing("values", value);
    }

    public AccessSafely afterCompleting(int times) {
        this.access = AccessSafely.afterCompleting((int)times);
        this.access.writingWith("ready", value -> this.readyCount.addAndGet((int)value));
        this.access.writingWith("terminate", value -> this.terminateCount.addAndGet((int)value));
        this.access.writingWith("value", value -> this.valueCount.addAndGet((int)value));
        this.access.writingWith("values", value -> this.values.add(value));
        this.access.readingWith("ready", () -> this.readyCount.get());
        this.access.readingWith("terminate", () -> this.terminateCount.get());
        this.access.readingWith("value", () -> this.valueCount.get());
        this.access.readingWith("values", () -> this.values);
        return this.access;
    }

    public int accessValueMustBe(String name, int expected) {
        int current = 0;
        for (int tries = 0; tries < 10; ++tries) {
            int value = (Integer)this.access.readFrom(name);
            if (value >= expected) {
                return value;
            }
            if (current != value) {
                current = value;
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return expected == 0 ? -1 : current;
    }

    public String toString() {
        return "SafeConsumerSink";
    }
}

