/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.reactivestreams.source;

import io.vlingo.common.Completes;
import io.vlingo.reactivestreams.Elements;
import io.vlingo.reactivestreams.Source;
import java.util.Iterator;

public class IterableSource<T>
implements Source<T> {
    private final Iterator<T> iterator;
    private final boolean slowIterable;

    public IterableSource(Iterable<T> iterable, boolean slowIterable) {
        this.iterator = iterable.iterator();
        this.slowIterable = slowIterable;
    }

    @Override
    public Completes<Elements<T>> next() {
        if (this.iterator.hasNext()) {
            Object[] element = new Object[]{this.iterator.next()};
            return Completes.withSuccess(new Elements<Object>(element, false));
        }
        return Completes.withSuccess(new Elements<Object>(new Object[0], true));
    }

    @Override
    public Completes<Elements<T>> next(int maximumElements) {
        return this.next();
    }

    @Override
    public Completes<Elements<T>> next(long index) {
        return this.next();
    }

    @Override
    public Completes<Elements<T>> next(long index, int maximumElements) {
        return this.next();
    }

    @Override
    public Completes<Boolean> isSlow() {
        return Completes.withSuccess((Object)this.slowIterable);
    }
}

