/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.reactivestreams.source;

import io.vlingo.common.Completes;
import io.vlingo.reactivestreams.Elements;
import io.vlingo.reactivestreams.Source;

public class LongRangeSource
implements Source<Long> {
    private long current;
    public final long endExclusive;
    public final long startInclusive;

    public LongRangeSource(long startInclusive, long endExclusive) {
        assert (startInclusive <= endExclusive);
        assert (startInclusive >= 0L && startInclusive <= Long.MAX_VALUE);
        this.startInclusive = startInclusive;
        assert (endExclusive >= 0L && endExclusive <= Long.MAX_VALUE);
        this.endExclusive = endExclusive;
        this.current = startInclusive;
    }

    @Override
    public Completes<Elements<Long>> next() {
        if (this.current < this.endExclusive) {
            Long[] element = new Long[]{this.current++};
            return Completes.withSuccess(new Elements<Long>(element, false));
        }
        return Completes.withSuccess(new Elements<Long>(new Long[0], true));
    }

    @Override
    public Completes<Elements<Long>> next(int maximumElements) {
        return this.next();
    }

    @Override
    public Completes<Elements<Long>> next(long index) {
        return this.next();
    }

    @Override
    public Completes<Elements<Long>> next(long index, int maximumElements) {
        return this.next();
    }

    @Override
    public Completes<Boolean> isSlow() {
        return Completes.withSuccess((Object)false);
    }

    public String toString() {
        return "LongRangeSource [startInclusive=" + this.startInclusive + " endExclusive=" + this.endExclusive + " current=" + this.current + "]";
    }
}

