/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.reactivestreams.source;

import io.vlingo.common.Completes;
import io.vlingo.reactivestreams.Elements;
import io.vlingo.reactivestreams.Source;
import java.util.function.Supplier;

public class SupplierSource<T>
implements Source<T> {
    private final boolean slowSupplier;
    private final Supplier<T> supplier;

    public SupplierSource(Supplier<T> supplier, boolean slowSupplier) {
        this.supplier = supplier;
        this.slowSupplier = slowSupplier;
    }

    @Override
    public Completes<Elements<T>> next() {
        T any = this.supplier.get();
        if (any != null) {
            Object[] elements = new Object[]{any};
            return Completes.withSuccess(new Elements<Object>(elements, false));
        }
        return Completes.withSuccess(new Elements<Object>(new Object[0], true));
    }

    @Override
    public Completes<Elements<T>> next(int maximumElements) {
        return this.next();
    }

    @Override
    public Completes<Elements<T>> next(long index) {
        return this.next();
    }

    @Override
    public Completes<Elements<T>> next(long index, int maximumElements) {
        return this.next();
    }

    @Override
    public Completes<Boolean> isSlow() {
        return Completes.withSuccess((Object)this.slowSupplier);
    }
}

