/*
 * Decompiled with CFR 0.152.
 */
package org.reactivestreams;

import io.vlingo.actors.Actor;
import io.vlingo.actors.DeadLetter;
import io.vlingo.actors.LocalMessage;
import io.vlingo.actors.Mailbox;
import io.vlingo.actors.Message;
import io.vlingo.common.SerializableConsumer;
import java.io.Serializable;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class Processor__Proxy<T, R>
implements Processor<T, R> {
    private static final String onSubscribeRepresentation1 = "onSubscribe(org.reactivestreams.Subscription)";
    private static final String onNextRepresentation2 = "onNext(T)";
    private static final String onErrorRepresentation3 = "onError(java.lang.Throwable)";
    private static final String onCompleteRepresentation4 = "onComplete()";
    private static final String subscribeRepresentation5 = "subscribe(org.reactivestreams.Subscriber<? super T>)";
    private final Actor actor;
    private final Mailbox mailbox;

    public Processor__Proxy(Actor actor, Mailbox mailbox) {
        this.actor = actor;
        this.mailbox = mailbox;
    }

    public void onSubscribe(Subscription arg0) {
        if (arg0 == null) {
            throw new NullPointerException("Subscription must not be null.");
        }
        if (!this.actor.isStopped()) {
            SerializableConsumer & Serializable consumer = (SerializableConsumer & Serializable)actor -> actor.onSubscribe(arg0);
            if (this.mailbox.isPreallocated()) {
                this.mailbox.send(this.actor, Processor.class, (SerializableConsumer)consumer, null, onSubscribeRepresentation1);
            } else {
                this.mailbox.send((Message)new LocalMessage(this.actor, Processor.class, (SerializableConsumer)consumer, onSubscribeRepresentation1));
            }
        } else {
            this.actor.deadLetters().failedDelivery(new DeadLetter(this.actor, onSubscribeRepresentation1));
        }
    }

    public void onNext(T arg0) {
        if (arg0 == null) {
            throw new NullPointerException("Element must not be null.");
        }
        if (!this.actor.isStopped()) {
            SerializableConsumer & Serializable consumer = (SerializableConsumer & Serializable)actor -> actor.onNext(arg0);
            if (this.mailbox.isPreallocated()) {
                this.mailbox.send(this.actor, Processor.class, (SerializableConsumer)consumer, null, onNextRepresentation2);
            } else {
                this.mailbox.send((Message)new LocalMessage(this.actor, Processor.class, (SerializableConsumer)consumer, onNextRepresentation2));
            }
        } else {
            this.actor.deadLetters().failedDelivery(new DeadLetter(this.actor, onNextRepresentation2));
        }
    }

    public void onError(Throwable arg0) {
        if (arg0 == null) {
            throw new NullPointerException("Exception must not be null.");
        }
        if (!this.actor.isStopped()) {
            SerializableConsumer & Serializable consumer = (SerializableConsumer & Serializable)actor -> actor.onError(arg0);
            if (this.mailbox.isPreallocated()) {
                this.mailbox.send(this.actor, Processor.class, (SerializableConsumer)consumer, null, onErrorRepresentation3);
            } else {
                this.mailbox.send((Message)new LocalMessage(this.actor, Processor.class, (SerializableConsumer)consumer, onErrorRepresentation3));
            }
        } else {
            this.actor.deadLetters().failedDelivery(new DeadLetter(this.actor, onErrorRepresentation3));
        }
    }

    public void onComplete() {
        if (!this.actor.isStopped()) {
            SerializableConsumer & Serializable consumer = (SerializableConsumer & Serializable)actor -> actor.onComplete();
            if (this.mailbox.isPreallocated()) {
                this.mailbox.send(this.actor, Processor.class, (SerializableConsumer)consumer, null, onCompleteRepresentation4);
            } else {
                this.mailbox.send((Message)new LocalMessage(this.actor, Processor.class, (SerializableConsumer)consumer, onCompleteRepresentation4));
            }
        } else {
            this.actor.deadLetters().failedDelivery(new DeadLetter(this.actor, onCompleteRepresentation4));
        }
    }

    public void subscribe(Subscriber<? super R> arg0) {
        if (arg0 == null) {
            throw new NullPointerException("Subscriber must not be null.");
        }
        if (!this.actor.isStopped()) {
            SerializableConsumer & Serializable consumer = (SerializableConsumer & Serializable)actor -> actor.subscribe(arg0);
            if (this.mailbox.isPreallocated()) {
                this.mailbox.send(this.actor, Processor.class, (SerializableConsumer)consumer, null, subscribeRepresentation5);
            } else {
                this.mailbox.send((Message)new LocalMessage(this.actor, Processor.class, (SerializableConsumer)consumer, subscribeRepresentation5));
            }
        } else {
            this.actor.deadLetters().failedDelivery(new DeadLetter(this.actor, subscribeRepresentation5));
        }
    }
}

