/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio;

import io.vlingo.symbio.Entry;
import io.vlingo.symbio.Metadata;
import java.util.Comparator;

public abstract class BaseEntry<T>
implements Entry<T> {
    private static final byte[] EmptyBytesData = new byte[0];
    private static final Object EmptyObjectData = new Object(){

        public String toString() {
            return "(empty)";
        }
    };
    private static final String EmptyTextData = "";
    private static final String UnknownId = "";
    private String id;
    private final T entryData;
    private final int entryVersion;
    private final Metadata metadata;
    private final String type;
    private final int typeVersion;

    public BaseEntry(String id, Class<?> type, int typeVersion, T entryData, int entryVersion, Metadata metadata) {
        if (id == null) {
            throw new IllegalArgumentException("Entry id must not be null.");
        }
        this.id = id;
        if (type == null) {
            throw new IllegalArgumentException("Entry type must not be null.");
        }
        this.type = type.getName();
        if (typeVersion <= 0) {
            throw new IllegalArgumentException("Entry typeVersion must be greater than 0.");
        }
        this.typeVersion = typeVersion;
        if (entryData == null) {
            throw new IllegalArgumentException("Entry entryData must not be null.");
        }
        this.entryData = entryData;
        this.entryVersion = entryVersion;
        if (metadata == null) {
            throw new IllegalArgumentException("Entry metadata must not be null.");
        }
        this.metadata = metadata;
    }

    public BaseEntry(String id, Class<?> type, int typeVersion, T entryData, Metadata metadata) {
        this(id, type, typeVersion, entryData, -1, metadata);
    }

    protected BaseEntry(String id, Class<?> type, int typeVersion, T entryData) {
        this(id, type, typeVersion, entryData, -1, Metadata.nullMetadata());
    }

    public BaseEntry(Class<?> type, int typeVersion, T entryData, Metadata metadata) {
        this("", type, typeVersion, entryData, -1, metadata);
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public T entryData() {
        return this.entryData;
    }

    @Override
    public int entryVersion() {
        return this.entryVersion;
    }

    @Override
    public Metadata metadata() {
        return this.metadata;
    }

    @Override
    public String typeName() {
        return this.type;
    }

    @Override
    public int typeVersion() {
        return this.typeVersion;
    }

    public BinaryEntry asBinaryEntry() {
        return (BinaryEntry)this;
    }

    public ObjectEntry<T> asObjectEntry() {
        return (ObjectEntry)this;
    }

    public TextEntry asTextEntry() {
        return (TextEntry)this;
    }

    @Override
    public boolean hasMetadata() {
        return !this.metadata.isEmpty();
    }

    public boolean isBinary() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    public boolean isObject() {
        return false;
    }

    public boolean isText() {
        return false;
    }

    @Override
    public <C> Class<C> typed() {
        return Entry.typed(this.type);
    }

    @Override
    public int compareTo(Entry<T> other) {
        BaseEntry that = (BaseEntry)other;
        int dataDiff = this.compareData(this, that);
        if (dataDiff != 0) {
            return dataDiff;
        }
        return Comparator.comparing(s -> s.id).thenComparing(s -> s.type).thenComparingInt(s -> s.typeVersion).thenComparing(s -> s.metadata).compare(this, that);
    }

    public int hashCode() {
        return 31 * this.id.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        return this.id.equals(((BaseEntry)other).id);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + " type=" + this.type + " typeVersion=" + this.typeVersion + " entryData=" + (this.isText() || this.isObject() ? this.entryData.toString() : "(binary)") + " entryVersion=" + this.entryVersion + " metadata=" + this.metadata + "]";
    }

    public void __internal__setId(String id) {
        this.id = id;
    }

    private int compareData(BaseEntry<T> state1, BaseEntry<T> state2) {
        if (state1.isText() && state2.isText()) {
            return ((String)state1.entryData).compareTo((String)state2.entryData);
        }
        if (state1.isBinary() && state2.isBinary()) {
            byte[] data1 = (byte[])state1.entryData;
            byte[] data2 = (byte[])state2.entryData;
            if (data1.length == data2.length) {
                for (int idx = 0; idx < data1.length; ++idx) {
                    if (data1[idx] == data2[idx]) continue;
                    return 1;
                }
                return 0;
            }
            return 1;
        }
        return 1;
    }

    public static final class NullEntry<T>
    extends BaseEntry<T> {
        public static NullEntry<byte[]> Binary = new NullEntry<byte[]>(BaseEntry.access$000());
        public static NullEntry<Object> Object = new NullEntry<Object>(BaseEntry.access$100());
        public static NullEntry<String> Text = new NullEntry<String>("");

        private NullEntry(T entryData) {
            super("", Object.class, 1, entryData, Metadata.nullMetadata());
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public Entry<T> withId(String id) {
            return this;
        }
    }

    public static final class TextEntry
    extends BaseEntry<String> {
        public TextEntry(String id, Class<?> type, int typeVersion, String entryData, int entryVersion, Metadata metadata) {
            super(id, type, typeVersion, entryData, entryVersion, metadata);
        }

        public TextEntry(String id, Class<?> type, int typeVersion, String entryData, Metadata metadata) {
            super(id, type, typeVersion, entryData, metadata);
        }

        public TextEntry(String id, Class<?> type, int typeVersion, String entryData) {
            super(id, type, typeVersion, entryData);
        }

        public TextEntry(Class<?> type, int typeVersion, String entryData, int entryVersion, Metadata metadata) {
            super("", type, typeVersion, entryData, entryVersion, metadata);
        }

        public TextEntry(Class<?> type, int typeVersion, String entryData, Metadata metadata) {
            super("", type, typeVersion, entryData, metadata);
        }

        public TextEntry() {
            super("", Object.class, 1, "", Metadata.nullMetadata());
        }

        @Override
        public boolean isEmpty() {
            return ((String)this.entryData()).isEmpty();
        }

        @Override
        public boolean isText() {
            return true;
        }

        @Override
        public Entry<String> withId(String id) {
            return new TextEntry(id, this.typed(), this.typeVersion(), (String)this.entryData());
        }
    }

    public static final class ObjectEntry<T>
    extends BaseEntry<Object> {
        public ObjectEntry(String id, Class<?> type, int typeVersion, String entryData, int entryVersion, Metadata metadata) {
            super(id, type, typeVersion, entryData, entryVersion, metadata);
        }

        public ObjectEntry(String id, Class<?> type, int typeVersion, T entryData, Metadata metadata) {
            super(id, type, typeVersion, entryData, metadata);
        }

        public ObjectEntry(String id, Class<?> type, int typeVersion, T entryData, int dataVersion) {
            super(id, type, typeVersion, entryData);
        }

        public ObjectEntry(Class<?> type, int typeVersion, String entryData, int entryVersion, Metadata metadata) {
            super("", type, typeVersion, entryData, entryVersion, metadata);
        }

        public ObjectEntry(Class<?> type, int typeVersion, T entryData, Metadata metadata) {
            super("", type, typeVersion, entryData, metadata);
        }

        public ObjectEntry() {
            super("", Object.class, 1, EmptyObjectData, Metadata.nullMetadata());
        }

        @Override
        public boolean isEmpty() {
            return this.entryData() == EmptyObjectData;
        }

        @Override
        public boolean isObject() {
            return true;
        }

        @Override
        public Entry<Object> withId(String id) {
            return new ObjectEntry(id, this.typed(), this.typeVersion(), this.entryData(), 1);
        }
    }

    public static final class BinaryEntry
    extends BaseEntry<byte[]> {
        public BinaryEntry(String id, Class<?> type, int typeVersion, byte[] entryData, int entryVersion, Metadata metadata) {
            super(id, type, typeVersion, entryData, entryVersion, metadata);
        }

        public BinaryEntry(String id, Class<?> type, int typeVersion, byte[] entryData, Metadata metadata) {
            super(id, type, typeVersion, entryData, metadata);
        }

        public BinaryEntry(String id, Class<?> type, int typeVersion, byte[] entryData) {
            super(id, type, typeVersion, entryData);
        }

        public BinaryEntry(Class<?> type, int typeVersion, byte[] entryData, int entryVersion, Metadata metadata) {
            super("", type, typeVersion, entryData, entryVersion, metadata);
        }

        public BinaryEntry(Class<?> type, int typeVersion, byte[] entryData, Metadata metadata) {
            super("", type, typeVersion, entryData, metadata);
        }

        public BinaryEntry() {
            super("", Object.class, 1, EmptyBytesData, Metadata.nullMetadata());
        }

        @Override
        public boolean isBinary() {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return ((byte[])this.entryData()).length == 0;
        }

        @Override
        public Entry<byte[]> withId(String id) {
            return new BinaryEntry(id, this.typed(), this.typeVersion(), (byte[])this.entryData());
        }
    }
}

