/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio;

import io.vlingo.symbio.Metadata;
import java.util.Collections;
import java.util.List;

public interface Entry<T>
extends Comparable<Entry<T>> {
    public static final int DefaultVersion = -1;

    public static <T> List<Entry<T>> none() {
        return Collections.emptyList();
    }

    public static <C> Class<C> typed(String type) {
        try {
            return Class.forName(type);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot get class for type: " + type);
        }
    }

    public String id();

    public T entryData();

    default public int entryVersion() {
        return -1;
    }

    public Metadata metadata();

    default public String simpleTypeName() {
        String typeName = this.typeName();
        int index = Math.max(typeName.lastIndexOf(46), typeName.lastIndexOf(36));
        return typeName.substring(index + 1);
    }

    public String typeName();

    default public String type() {
        return this.typeName();
    }

    public int typeVersion();

    public boolean hasMetadata();

    public boolean isEmpty();

    public boolean isNull();

    public <C> Class<C> typed();

    public Entry<T> withId(String var1);
}

