/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio;

import io.vlingo.actors.World;
import io.vlingo.symbio.BaseEntry;
import io.vlingo.symbio.DefaultTextEntryAdapter;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.EntryAdapter;
import io.vlingo.symbio.Metadata;
import io.vlingo.symbio.Source;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;

public class EntryAdapterProvider {
    static final String INTERNAL_NAME = UUID.randomUUID().toString();
    private final Map<Class<?>, EntryAdapter<?, ?>> adapters = new HashMap();
    private final Map<String, EntryAdapter<?, ?>> namedAdapters = new HashMap();
    private final EntryAdapter<Source<?>, BaseEntry.TextEntry> defaultTextEntryAdapter = new DefaultTextEntryAdapter();

    public static EntryAdapterProvider instance(World world) {
        EntryAdapterProvider instance = (EntryAdapterProvider)world.resolveDynamic(INTERNAL_NAME, EntryAdapterProvider.class);
        if (instance == null) {
            instance = new EntryAdapterProvider(world);
        }
        return instance;
    }

    public EntryAdapterProvider(World world) {
        this();
        world.registerDynamic(INTERNAL_NAME, (Object)this);
    }

    public EntryAdapterProvider() {
    }

    public <S extends Source<?>, E extends Entry<?>> void registerAdapter(Class<S> sourceType, EntryAdapter<S, E> adapter) {
        this.adapters.put(sourceType, adapter);
        this.namedAdapters.put(sourceType.getName(), adapter);
    }

    public <S extends Source<?>, E extends Entry<?>> void registerAdapter(Class<S> sourceType, EntryAdapter<S, E> adapter, BiConsumer<Class<S>, EntryAdapter<S, E>> consumer) {
        this.adapters.put(sourceType, adapter);
        this.namedAdapters.put(sourceType.getName(), adapter);
        consumer.accept(sourceType, adapter);
    }

    public <S extends Source<?>, E extends Entry<?>> List<E> asEntries(List<S> sources, int version, Metadata metadata) {
        ArrayList<E> entries = new ArrayList<E>(sources.size());
        for (Source source : sources) {
            entries.add(this.asEntry(source, version, metadata));
        }
        return entries;
    }

    public <S extends Source<?>, E extends Entry<?>> List<E> asEntries(List<S> sources, Metadata metadata) {
        return this.asEntries(sources, -1, metadata);
    }

    public <S extends Source<?>, E extends Entry<?>> E asEntry(S source, int startingVersion, Metadata metadata) {
        EntryAdapter<S, E> adapter = this.adapter(source.getClass());
        if (adapter != null) {
            return adapter.toEntry(source, startingVersion, metadata);
        }
        return (E)this.defaultTextEntryAdapter.toEntry(source, startingVersion, metadata);
    }

    public <S extends Source<?>, E extends Entry<?>> E asEntry(S source, Metadata metadata) {
        return this.asEntry(source, -1, metadata);
    }

    public <S extends Source<?>, E extends Entry<?>> List<S> asSources(List<E> entries) {
        ArrayList<S> sources = new ArrayList<S>(entries.size());
        for (Entry entry : entries) {
            sources.add(this.asSource(entry));
        }
        return sources;
    }

    public <S extends Source<?>, E extends Entry<?>> S asSource(E entry) {
        EntryAdapter<S, E> adapter = this.namedAdapter(entry);
        if (adapter != null) {
            return adapter.fromEntry(entry);
        }
        return (S)this.defaultTextEntryAdapter.fromEntry((BaseEntry.TextEntry)entry);
    }

    private <S extends Source<?>, E extends Entry<?>> EntryAdapter<S, E> adapter(Class<?> sourceType) {
        EntryAdapter<?, ?> adapter = this.adapters.get(sourceType);
        return adapter;
    }

    private <S extends Source<?>, E extends Entry<?>> EntryAdapter<S, E> namedAdapter(E entry) {
        EntryAdapter<?, ?> adapter = this.namedAdapters.get(entry.typeName());
        return adapter;
    }
}

