/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio;

import java.util.Comparator;
import java.util.Optional;

public class Metadata
implements Comparable<Metadata> {
    public static final Object EmptyObject = new Object(){

        public String toString() {
            return "(empty)";
        }
    };
    public final Object object;
    public final String operation;
    public final String value;

    public static Metadata nullMetadata() {
        return new Metadata(EmptyObject, "", "");
    }

    public static Metadata withObject(Object object) {
        return new Metadata(object, "", "");
    }

    public static Metadata withOperation(String operation) {
        return new Metadata(EmptyObject, "", operation);
    }

    public static Metadata withValue(String value) {
        return new Metadata(EmptyObject, value, "");
    }

    public static Metadata with(String value, String operation) {
        return new Metadata(EmptyObject, value, operation);
    }

    public static Metadata with(Object object, String value, String operation) {
        return new Metadata(object, value, operation);
    }

    public static Metadata with(Object object, String value, Class<?> operationType) {
        return Metadata.with(object, value, operationType, true);
    }

    public static Metadata with(Object object, String value, Class<?> operationType, boolean compact) {
        String operation = compact ? operationType.getSimpleName() : operationType.getName();
        return new Metadata(object, value, operation);
    }

    public Metadata(Object object, String value, String operation) {
        this.object = object == null ? EmptyObject : object;
        this.value = value == null ? "" : value;
        this.operation = operation == null ? "" : operation;
    }

    public Metadata(String value, String operation) {
        this(EmptyObject, value, operation);
    }

    public Metadata() {
        this(EmptyObject, "", "");
    }

    public boolean hasObject() {
        return this.object != EmptyObject;
    }

    public boolean hasOperation() {
        return !this.operation.isEmpty();
    }

    public boolean hasValue() {
        return !this.value.isEmpty();
    }

    public boolean isEmpty() {
        return !this.hasOperation() && !this.hasValue();
    }

    public Object object() {
        return this.object;
    }

    public Optional<Object> optionalObject() {
        return this.hasObject() ? Optional.of(this.object) : Optional.empty();
    }

    public String operation() {
        return this.operation;
    }

    public String value() {
        return this.value;
    }

    public <T> T typedObject() {
        return (T)this.object;
    }

    @Override
    public int compareTo(Metadata other) {
        if (!this.object.equals(other.object)) {
            return 1;
        }
        return Comparator.comparing(m -> m.value).thenComparing(m -> m.operation).compare(this, other);
    }

    public int hashCode() {
        return 31 * this.value.hashCode() + this.operation.hashCode() + this.object.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        Metadata otherMetadata = (Metadata)other;
        return this.value.equals(otherMetadata.value) && this.operation.equals(otherMetadata.operation) && this.object.equals(otherMetadata.object);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[value=" + this.value + " operation=" + this.operation + " object=" + this.object + "]";
    }
}

