/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio;

import io.vlingo.common.version.SemanticVersion;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;

public abstract class Source<T> {
    public final long dateTimeSourced;
    public final int sourceTypeVersion;

    public static <T> Source<T> nulled() {
        return new NullSource();
    }

    @SafeVarargs
    public static <T> List<Source<T>> all(Source<T> ... sources) {
        return Arrays.asList(sources);
    }

    public static <T> List<Source<T>> all(List<Source<T>> sources) {
        ArrayList<Source<T>> all = new ArrayList<Source<T>>(sources.size());
        for (Source<T> source : sources) {
            if (source.isNull()) continue;
            all.add(source);
        }
        return all;
    }

    public static <T> List<Source<T>> none() {
        return Collections.emptyList();
    }

    public String id() {
        return "";
    }

    public boolean isNull() {
        return false;
    }

    public String typeName() {
        return this.getClass().getSimpleName();
    }

    public int hashCode() {
        return this.id().hashCode();
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass() != this.getClass()) {
            return false;
        }
        return this.id().equals(((Source)other).id());
    }

    public String toString() {
        String id = this.id();
        return "Source [id=" + (id == null || id.isEmpty() ? "(none)" : id) + " dateTimeSourced=" + LocalDateTime.ofInstant(Instant.ofEpochMilli(this.dateTimeSourced), TimeZone.getDefault().toZoneId()) + " sourceTypeVersion=" + SemanticVersion.toString((int)this.sourceTypeVersion) + "]";
    }

    protected Source() {
        this(SemanticVersion.toValue((int)1, (int)0, (int)0));
    }

    protected Source(int sourceTypeVersion) {
        assert (sourceTypeVersion > 0);
        this.dateTimeSourced = System.currentTimeMillis();
        this.sourceTypeVersion = sourceTypeVersion;
    }

    private static class NullSource<T>
    extends Source<T> {
        private NullSource() {
        }

        @Override
        public boolean isNull() {
            return true;
        }
    }
}

