/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio;

import io.vlingo.symbio.Metadata;
import java.util.Comparator;

public abstract class State<T>
implements Comparable<State<T>> {
    public static final String NoOp = "";
    private static final byte[] EmptyBytesData = new byte[0];
    private static final Object EmptyObjectData = new Object(){

        public String toString() {
            return "(empty)";
        }
    };
    private static final String EmptyTextData = "";
    public final String id;
    public final T data;
    public final int dataVersion;
    public final Metadata metadata;
    public final String type;
    public final int typeVersion;

    protected State(String id, Class<?> type, int typeVersion, T data, int dataVersion, Metadata metadata) {
        if (id == null) {
            throw new IllegalArgumentException("State id must not be null.");
        }
        this.id = id;
        if (type == null) {
            throw new IllegalArgumentException("State type must not be null.");
        }
        this.type = type.getName();
        if (typeVersion <= 0) {
            throw new IllegalArgumentException("State typeVersion must be greater than 0.");
        }
        this.typeVersion = typeVersion;
        if (data == null) {
            throw new IllegalArgumentException("State data must not be null.");
        }
        this.data = data;
        if (dataVersion <= 0) {
            throw new IllegalArgumentException("State dataVersion must be greater than 0.");
        }
        this.dataVersion = dataVersion;
        this.metadata = metadata == null ? Metadata.nullMetadata() : metadata;
    }

    protected State(String id, Class<?> type, int typeVersion, T data, int dataVersion) {
        this(id, type, typeVersion, data, dataVersion, Metadata.nullMetadata());
    }

    public BinaryState asBinaryState() {
        return (BinaryState)this;
    }

    public ObjectState<T> asObjectState() {
        return (ObjectState)this;
    }

    public TextState asTextState() {
        return (TextState)this;
    }

    public boolean hasMetadata() {
        return !this.metadata.isEmpty();
    }

    public boolean isBinary() {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isNull() {
        return false;
    }

    public boolean isObject() {
        return false;
    }

    public boolean isText() {
        return false;
    }

    public <C> Class<C> typed() {
        try {
            return Class.forName(this.type);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot get class for type: " + this.type);
        }
    }

    @Override
    public int compareTo(State<T> other) {
        int dataDiff = this.compareData(this, other);
        if (dataDiff != 0) {
            return dataDiff;
        }
        return Comparator.comparing(s -> s.id).thenComparing(s -> s.type).thenComparingInt(s -> s.typeVersion).thenComparingInt(s -> s.dataVersion).thenComparing(s -> s.metadata).compare(this, other);
    }

    public int hashCode() {
        return 31 * this.id.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        return this.id.equals(((State)other).id);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + " type=" + this.type + " typeVersion=" + this.typeVersion + " data=" + (this.isText() || this.isObject() ? this.data.toString() : "(binary)") + " dataVersion=" + this.dataVersion + " metadata=" + this.metadata + "]";
    }

    private int compareData(State<T> state1, State<T> state2) {
        if (state1.isText() && state2.isText()) {
            return ((String)state1.data).compareTo((String)state2.data);
        }
        if (state1.isBinary() && state2.isBinary()) {
            byte[] data1 = (byte[])state1.data;
            byte[] data2 = (byte[])state2.data;
            if (data1.length == data2.length) {
                for (int idx = 0; idx < data1.length; ++idx) {
                    if (data1[idx] == data2[idx]) continue;
                    return 1;
                }
                return 0;
            }
            return 1;
        }
        return 1;
    }

    public static final class TextState
    extends State<String> {
        public static final TextState Null = new TextState();

        public TextState(String id, Class<?> type, int typeVersion, String data, int dataVersion, Metadata metadata) {
            super(id, type, typeVersion, data, dataVersion, metadata);
        }

        public TextState(String id, Class<?> type, int typeVersion, String data, int dataVersion) {
            super(id, type, typeVersion, data, dataVersion);
        }

        public TextState() {
            super("", Object.class, 1, "", 1, Metadata.nullMetadata());
        }

        @Override
        public boolean isEmpty() {
            return ((String)this.data).isEmpty();
        }

        @Override
        public boolean isNull() {
            return this == Null;
        }

        @Override
        public boolean isText() {
            return true;
        }
    }

    public static final class ObjectState<T>
    extends State<Object> {
        public static final ObjectState<Object> Null = new ObjectState();

        public ObjectState(String id, Class<?> type, int typeVersion, T data, int dataVersion, Metadata metadata) {
            super(id, type, typeVersion, data, dataVersion, metadata);
        }

        public ObjectState(String id, Class<?> type, int typeVersion, T data, int dataVersion) {
            super(id, type, typeVersion, data, dataVersion);
        }

        public ObjectState() {
            super("", Object.class, 1, EmptyObjectData, 1, Metadata.nullMetadata());
        }

        @Override
        public boolean isEmpty() {
            return this.data == EmptyObjectData;
        }

        @Override
        public boolean isNull() {
            return this == Null;
        }

        @Override
        public boolean isObject() {
            return true;
        }
    }

    public static final class BinaryState
    extends State<byte[]> {
        public static final BinaryState Null = new BinaryState();

        public BinaryState(String id, Class<?> type, int typeVersion, byte[] data, int dataVersion, Metadata metadata) {
            super(id, type, typeVersion, data, dataVersion, metadata);
        }

        public BinaryState(String id, Class<?> type, int typeVersion, byte[] data, int dataVersion) {
            super(id, type, typeVersion, data, dataVersion);
        }

        public BinaryState() {
            super("", Object.class, 1, EmptyBytesData, 1, Metadata.nullMetadata());
        }

        @Override
        public boolean isBinary() {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return ((byte[])this.data).length == 0;
        }

        @Override
        public boolean isNull() {
            return this == Null;
        }
    }
}

