/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio;

import io.vlingo.actors.World;
import io.vlingo.symbio.DefaultTextStateAdapter;
import io.vlingo.symbio.Metadata;
import io.vlingo.symbio.State;
import io.vlingo.symbio.StateAdapter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;

public class StateAdapterProvider {
    static final String INTERNAL_NAME = UUID.randomUUID().toString();
    private final Map<Class<?>, StateAdapter<?, ?>> adapters = new HashMap();
    private final Map<String, StateAdapter<?, ?>> namedAdapters = new HashMap();
    private final StateAdapter<Object, State.TextState> defaultTextStateAdapter = new DefaultTextStateAdapter();

    public static StateAdapterProvider instance(World world) {
        StateAdapterProvider instance = (StateAdapterProvider)world.resolveDynamic(INTERNAL_NAME, StateAdapterProvider.class);
        if (instance == null) {
            instance = new StateAdapterProvider(world);
        }
        return instance;
    }

    public StateAdapterProvider(World world) {
        this();
        world.registerDynamic(INTERNAL_NAME, (Object)this);
    }

    public StateAdapterProvider() {
    }

    public <S, ST extends State<?>> void registerAdapter(Class<S> stateType, StateAdapter<S, ST> adapter) {
        this.adapters.put(stateType, adapter);
        this.namedAdapters.put(stateType.getName(), adapter);
    }

    public <S, ST extends State<?>> void registerAdapter(Class<S> stateType, StateAdapter<S, ST> adapter, BiConsumer<Class<S>, StateAdapter<S, ST>> consumer) {
        this.adapters.put(stateType, adapter);
        this.namedAdapters.put(stateType.getName(), adapter);
        consumer.accept(stateType, adapter);
    }

    public <S, ST extends State<?>> ST asRaw(String id, S state, int stateVersion) {
        return this.asRaw(id, state, stateVersion, Metadata.nullMetadata());
    }

    public <S, ST extends State<?>> ST asRaw(String id, S state, int stateVersion, Metadata metadata) {
        StateAdapter<S, ST> adapter = this.adapter(state.getClass());
        if (adapter != null) {
            return adapter.toRawState(id, state, stateVersion, metadata);
        }
        return (ST)this.defaultTextStateAdapter.toRawState(id, state, stateVersion, metadata);
    }

    public <S, ST extends State<?>> S fromRaw(ST state) {
        StateAdapter<S, ST> adapter = this.namedAdapter(state);
        if (adapter != null) {
            return adapter.fromRawState(state);
        }
        return (S)this.defaultTextStateAdapter.fromRawState((State.TextState)state);
    }

    private <S, ST extends State<?>> StateAdapter<S, ST> adapter(Class<?> stateType) {
        StateAdapter<?, ?> adapter = this.adapters.get(stateType);
        return adapter;
    }

    private <S, ST extends State<?>> StateAdapter<S, ST> namedAdapter(ST state) {
        StateAdapter<?, ?> adapter = this.namedAdapters.get(state.type);
        return adapter;
    }
}

