/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store;

import io.vlingo.symbio.store.ListQueryExpression;
import io.vlingo.symbio.store.MapQueryExpression;
import io.vlingo.symbio.store.QueryMode;

public class QueryExpression {
    public final QueryMode mode;
    public final String query;
    public final Class<?> type;

    public static QueryExpression using(Class<?> type, String query) {
        return new QueryExpression(type, query);
    }

    public static QueryExpression using(Class<?> type, String query, QueryMode mode) {
        return new QueryExpression(type, query, mode);
    }

    public QueryExpression(Class<?> type, String query) {
        this(type, query, QueryMode.ReadOnly);
    }

    public QueryExpression(Class<?> type, String query, QueryMode mode) {
        this.type = type;
        this.query = query;
        this.mode = mode;
    }

    public ListQueryExpression asListQueryExpression() {
        return (ListQueryExpression)this;
    }

    public MapQueryExpression asMapQueryExpression() {
        return (MapQueryExpression)this;
    }

    public boolean isListQueryExpression() {
        return false;
    }

    public boolean isMapQueryExpression() {
        return false;
    }

    public String toString() {
        return "QueryExpression[type=" + this.type.getName() + " query=" + this.query + " mode=" + (Object)((Object)this.mode) + "]";
    }
}

