/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.dispatch;

import io.vlingo.symbio.Entry;
import io.vlingo.symbio.State;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Dispatchable<E extends Entry<?>, RS extends State<?>> {
    private final String id;
    private final LocalDateTime createdOn;
    private final RS state;
    private final List<E> entries;

    public Dispatchable(String id, LocalDateTime createdOn, RS state, List<E> entries) {
        this.id = id;
        this.createdOn = createdOn;
        this.state = state;
        this.entries = entries;
    }

    public String id() {
        return this.id;
    }

    public LocalDateTime createdOn() {
        return this.createdOn;
    }

    public Optional<RS> state() {
        return Optional.ofNullable(this.state);
    }

    public List<E> entries() {
        return this.entries;
    }

    public boolean hasEntries() {
        return this.entries != null && !this.entries.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dispatchable that = (Dispatchable)o;
        return this.id.equals(that.id);
    }

    public <S> State<S> typedState() {
        return this.state;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

