/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.dispatch.control;

import io.vlingo.actors.Actor;
import io.vlingo.common.Cancellable;
import io.vlingo.common.Scheduled;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.State;
import io.vlingo.symbio.store.Result;
import io.vlingo.symbio.store.dispatch.ConfirmDispatchedResultInterest;
import io.vlingo.symbio.store.dispatch.Dispatchable;
import io.vlingo.symbio.store.dispatch.Dispatcher;
import io.vlingo.symbio.store.dispatch.DispatcherControl;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;

public class DispatcherControlActor
extends Actor
implements DispatcherControl,
Scheduled<Object> {
    private static final long DEFAULT_REDISPATCH_DELAY = 2000L;
    private final List<Dispatcher<Dispatchable<? extends Entry<?>, ? extends State<?>>>> dispatchers;
    private final DispatcherControl.DispatcherControlDelegate<? extends Entry<?>, ? extends State<?>> delegate;
    private final Cancellable cancellable;
    private final long confirmationExpiration;

    public DispatcherControlActor(List<Dispatcher<Dispatchable<? extends Entry<?>, ? extends State<?>>>> dispatchers, DispatcherControl.DispatcherControlDelegate<? extends Entry<?>, ? extends State<?>> delegate, long checkConfirmationExpirationInterval, long confirmationExpiration) {
        this.dispatchers = dispatchers;
        this.delegate = delegate;
        this.confirmationExpiration = confirmationExpiration;
        this.cancellable = this.scheduler().schedule((Scheduled)this, null, 2000L, checkConfirmationExpirationInterval);
        this.dispatchers.forEach(d -> d.controlWith(this));
    }

    public void intervalSignal(Scheduled<Object> scheduled, Object data) {
        this.dispatchUnconfirmed();
    }

    @Override
    public void confirmDispatched(String dispatchId, ConfirmDispatchedResultInterest interest) {
        try {
            this.delegate.confirmDispatched(dispatchId);
            interest.confirmDispatchedResultedIn(Result.Success, dispatchId);
        }
        catch (Exception e) {
            this.logger().error(this.getClass().getSimpleName() + " confirmDispatched() failed because: " + e.getMessage(), (Throwable)e);
            interest.confirmDispatchedResultedIn(Result.Failure, dispatchId);
        }
    }

    @Override
    public void dispatchUnconfirmed() {
        try {
            LocalDateTime now = LocalDateTime.now();
            Collection<Dispatchable<Entry<?>, State<?>>> dispatchables = this.delegate.allUnconfirmedDispatchableStates();
            for (Dispatchable<Entry<?>, State<?>> dispatchable : dispatchables) {
                LocalDateTime then = dispatchable.createdOn();
                Duration duration = Duration.between(then, now);
                if (Math.abs(duration.toMillis()) <= this.confirmationExpiration) continue;
                this.dispatchers.forEach(d -> d.dispatch(dispatchable));
            }
        }
        catch (Exception e) {
            this.logger().error(this.getClass().getSimpleName() + " dispatchUnconfirmed() failed because: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void stop() {
        if (this.cancellable != null) {
            this.cancellable.cancel();
        }
        this.delegate.stop();
        super.stop();
    }
}

