/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.gap;

import io.vlingo.actors.Actor;
import io.vlingo.actors.CompletesEventually;
import io.vlingo.actors.Stage;
import io.vlingo.common.Scheduled;
import io.vlingo.common.Scheduler;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.store.gap.GappedEntries;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class GapRetryReader<T extends Entry<?>> {
    private final Scheduled<RetryGappedEntries<T>> actor;
    private final Scheduler scheduler;

    public GapRetryReader(Stage stage, Scheduler scheduler) {
        this.actor = (Scheduled)stage.actorFor(Scheduled.class, GapsFillUpActor.class, new Object[0]);
        this.scheduler = scheduler;
    }

    private Set<Long> collectIds(List<T> entries) {
        if (entries == null) {
            return new HashSet<Long>();
        }
        return entries.stream().map(e -> Long.parseLong(e.id())).collect(Collectors.toSet());
    }

    public List<Long> detectGaps(T entry, long startIndex) {
        List<Object> entries = entry == null ? new ArrayList() : Collections.singletonList(entry);
        return this.detectGaps(entries, startIndex, 1L);
    }

    public List<Long> detectGaps(List<T> entries, long startIndex, long count) {
        Set<Long> allIds = this.collectIds(entries);
        ArrayList<Long> gapIds = new ArrayList<Long>();
        for (long index = 0L; index < count; ++index) {
            if (allIds.contains(startIndex + index)) continue;
            gapIds.add(startIndex + index);
        }
        return gapIds;
    }

    public void readGaps(GappedEntries<T> gappedEntries, int retries, long retryInterval, Function<List<Long>, List<T>> gappedReader) {
        RetryGappedEntries<T> entries = new RetryGappedEntries<T>(gappedEntries, 1, retries, retryInterval, gappedReader);
        this.scheduler.scheduleOnce(this.actor, entries, 0L, retryInterval);
    }

    public static class GapsFillUpActor<T extends Entry<?>>
    extends Actor
    implements Scheduled<RetryGappedEntries<T>> {
        public void intervalSignal(Scheduled<RetryGappedEntries<T>> scheduled, RetryGappedEntries<T> data) {
            Function gappedReader = data.gappedReader;
            List fillups = (List)gappedReader.apply(data.gappedEntries.getGapIds());
            GappedEntries nextGappedEntries = data.gappedEntries.fillupWith(fillups);
            if (!nextGappedEntries.containGaps() || !data.moreRetries()) {
                CompletesEventually eventually = data.gappedEntries.getEventually();
                if (nextGappedEntries.size() == 1) {
                    eventually.with(nextGappedEntries.getFirst().orElse(null));
                } else {
                    eventually.with(nextGappedEntries.getSortedLoadedEntries());
                }
            } else {
                RetryGappedEntries<T> nextData = data.nextRetry(nextGappedEntries);
                this.scheduler().scheduleOnce(scheduled, nextData, 0L, data.retryInterval);
            }
        }
    }

    static class RetryGappedEntries<T extends Entry<?>> {
        private final GappedEntries<T> gappedEntries;
        private final int currentRetry;
        private final int retries;
        private final long retryInterval;
        private final Function<List<Long>, List<T>> gappedReader;

        RetryGappedEntries(GappedEntries<T> gappedEntries, int currentRetry, int retries, long retryInterval, Function<List<Long>, List<T>> gappedReader) {
            this.gappedEntries = gappedEntries;
            this.currentRetry = currentRetry;
            this.retries = retries;
            this.retryInterval = retryInterval;
            this.gappedReader = gappedReader;
        }

        boolean moreRetries() {
            return this.currentRetry < this.retries;
        }

        RetryGappedEntries<T> nextRetry(GappedEntries<T> nextGappedEntries) {
            return new RetryGappedEntries<T>(nextGappedEntries, this.currentRetry + 1, this.retries, this.retryInterval, this.gappedReader);
        }
    }
}

