/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.gap;

import io.vlingo.actors.CompletesEventually;
import io.vlingo.symbio.Entry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;

public class GappedEntries<T extends Entry<?>> {
    private final List<T> loadedEntries;
    private final List<Long> gapIds;
    private final CompletesEventually eventually;

    public GappedEntries(List<T> loadedEntries, List<Long> gapIds, CompletesEventually eventually) {
        this.loadedEntries = loadedEntries;
        this.gapIds = gapIds;
        this.eventually = eventually;
    }

    public List<T> getLoadedEntries() {
        return this.loadedEntries;
    }

    private int compare(T e1, T e2) {
        long id1 = Long.parseLong(e1.id());
        long id2 = Long.parseLong(e2.id());
        return Long.compare(id1, id2);
    }

    public List<T> getSortedLoadedEntries() {
        TreeSet<T> sorted = new TreeSet<T>(this::compare);
        sorted.addAll(this.loadedEntries);
        return new ArrayList(sorted);
    }

    public List<Long> getGapIds() {
        return this.gapIds;
    }

    public CompletesEventually getEventually() {
        return this.eventually;
    }

    public boolean containGaps() {
        return !this.gapIds.isEmpty();
    }

    public int size() {
        return this.loadedEntries.size() + this.gapIds.size();
    }

    public Optional<T> getFirst() {
        if (this.loadedEntries.size() > 0) {
            return Optional.of(this.loadedEntries.get(0));
        }
        return Optional.empty();
    }

    public GappedEntries<T> fillupWith(List<T> fillups) {
        ArrayList<T> newLoadedEntries = new ArrayList<T>(this.loadedEntries);
        ArrayList<Long> newGapIds = new ArrayList<Long>(this.gapIds);
        for (Entry fillup : fillups) {
            Long fillupId = Long.parseLong(fillup.id());
            newGapIds.remove(fillupId);
            newLoadedEntries.add(fillup);
        }
        return new GappedEntries<T>(newLoadedEntries, newGapIds, this.eventually);
    }
}

