/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.journal;

import io.vlingo.actors.Actor;
import io.vlingo.actors.Stage;
import io.vlingo.common.Completes;
import io.vlingo.common.Outcome;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.Metadata;
import io.vlingo.symbio.Source;
import io.vlingo.symbio.State;
import io.vlingo.symbio.store.Result;
import io.vlingo.symbio.store.StorageException;
import io.vlingo.symbio.store.dispatch.Dispatchable;
import io.vlingo.symbio.store.dispatch.Dispatcher;
import io.vlingo.symbio.store.journal.JournalReader;
import io.vlingo.symbio.store.journal.StreamReader;
import java.util.List;
import java.util.Optional;

public interface Journal<T> {
    public static final long DefaultCheckConfirmationExpirationInterval = 1000L;
    public static final long DefaultConfirmationExpiration = 1000L;

    public static <A extends Actor, T, RS extends State<?>> Journal<T> using(Stage stage, Class<A> implementor, List<Dispatcher<Dispatchable<Entry<T>, RS>>> dispatchers, Object ... additional) {
        return additional.length == 0 ? (Journal)stage.actorFor(Journal.class, implementor, new Object[]{dispatchers}) : (Journal)stage.actorFor(Journal.class, implementor, new Object[]{dispatchers, additional});
    }

    public static <A extends Actor, T, RS extends State<?>> Journal<T> using(Stage stage, Class<A> implementor, Dispatcher<Dispatchable<Entry<T>, RS>> dispatcher, Object ... additional) {
        return additional.length == 0 ? (Journal)stage.actorFor(Journal.class, implementor, new Object[]{dispatcher}) : (Journal)stage.actorFor(Journal.class, implementor, new Object[]{dispatcher, additional});
    }

    default public <S, ST> void append(String streamName, int streamVersion, Source<S> source, AppendResultInterest interest, Object object) {
        this.append(streamName, streamVersion, source, Metadata.nullMetadata(), interest, object);
    }

    public <S, ST> void append(String var1, int var2, Source<S> var3, Metadata var4, AppendResultInterest var5, Object var6);

    default public <S, ST> void appendWith(String streamName, int streamVersion, Source<S> source, ST snapshot, AppendResultInterest interest, Object object) {
        this.appendWith(streamName, streamVersion, source, Metadata.nullMetadata(), snapshot, interest, object);
    }

    public <S, ST> void appendWith(String var1, int var2, Source<S> var3, Metadata var4, ST var5, AppendResultInterest var6, Object var7);

    default public <S, ST> void appendAll(String streamName, int fromStreamVersion, List<Source<S>> sources, AppendResultInterest interest, Object object) {
        this.appendAll(streamName, fromStreamVersion, sources, Metadata.nullMetadata(), interest, object);
    }

    public <S, ST> void appendAll(String var1, int var2, List<Source<S>> var3, Metadata var4, AppendResultInterest var5, Object var6);

    default public <S, ST> void appendAllWith(String streamName, int fromStreamVersion, List<Source<S>> sources, ST snapshot, AppendResultInterest interest, Object object) {
        this.appendAllWith(streamName, fromStreamVersion, sources, Metadata.nullMetadata(), snapshot, interest, object);
    }

    public <S, ST> void appendAllWith(String var1, int var2, List<Source<S>> var3, Metadata var4, ST var5, AppendResultInterest var6, Object var7);

    public <ET extends Entry<?>> Completes<JournalReader<ET>> journalReader(String var1);

    public Completes<StreamReader<T>> streamReader(String var1);

    public static interface TextJournal
    extends Journal<String> {
    }

    public static interface ObjectJournal
    extends Journal<Object> {
    }

    public static interface BinaryJournal
    extends Journal<byte[]> {
    }

    public static interface AppendResultInterest {
        public <S, ST> void appendResultedIn(Outcome<StorageException, Result> var1, String var2, int var3, Source<S> var4, Optional<ST> var5, Object var6);

        public <S, ST> void appendResultedIn(Outcome<StorageException, Result> var1, String var2, int var3, Source<S> var4, Metadata var5, Optional<ST> var6, Object var7);

        public <S, ST> void appendAllResultedIn(Outcome<StorageException, Result> var1, String var2, int var3, List<Source<S>> var4, Optional<ST> var5, Object var6);

        public <S, ST> void appendAllResultedIn(Outcome<StorageException, Result> var1, String var2, int var3, List<Source<S>> var4, Metadata var5, Optional<ST> var6, Object var7);
    }
}

