/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.journal.inmemory;

import io.vlingo.actors.Definition;
import io.vlingo.actors.Stoppable;
import io.vlingo.actors.World;
import io.vlingo.common.Completes;
import io.vlingo.common.Outcome;
import io.vlingo.common.Success;
import io.vlingo.symbio.BaseEntry;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.EntryAdapterProvider;
import io.vlingo.symbio.Metadata;
import io.vlingo.symbio.Source;
import io.vlingo.symbio.State;
import io.vlingo.symbio.StateAdapterProvider;
import io.vlingo.symbio.store.Result;
import io.vlingo.symbio.store.StorageException;
import io.vlingo.symbio.store.dispatch.Dispatchable;
import io.vlingo.symbio.store.dispatch.Dispatcher;
import io.vlingo.symbio.store.dispatch.DispatcherControl;
import io.vlingo.symbio.store.dispatch.control.DispatcherControlActor;
import io.vlingo.symbio.store.dispatch.inmemory.InMemoryDispatcherControlDelegate;
import io.vlingo.symbio.store.journal.Journal;
import io.vlingo.symbio.store.journal.JournalReader;
import io.vlingo.symbio.store.journal.StreamReader;
import io.vlingo.symbio.store.journal.inmemory.InMemoryJournalReader;
import io.vlingo.symbio.store.journal.inmemory.InMemoryStreamReader;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;

public class InMemoryJournal<T, RS extends State<?>>
implements Journal<T>,
Stoppable {
    private final EntryAdapterProvider entryAdapterProvider;
    private final StateAdapterProvider stateAdapterProvider;
    private final List<Entry<T>> journal;
    private final Map<String, JournalReader<? extends Entry<?>>> journalReaders;
    private final Map<String, StreamReader<T>> streamReaders;
    private final Map<String, Map<Integer, Integer>> streamIndexes;
    private final Map<String, RS> snapshots;
    private final List<Dispatchable<Entry<T>, RS>> dispatchables;
    private final List<Dispatcher<Dispatchable<Entry<T>, RS>>> dispatchers;
    private final DispatcherControl dispatcherControl;

    public InMemoryJournal(List<Dispatcher<Dispatchable<Entry<T>, RS>>> dispatchers, World world, long checkConfirmationExpirationInterval, long confirmationExpiration) {
        this.entryAdapterProvider = EntryAdapterProvider.instance(world);
        this.stateAdapterProvider = StateAdapterProvider.instance(world);
        this.journal = new ArrayList<Entry<T>>();
        this.journalReaders = new HashMap(1);
        this.streamReaders = new HashMap<String, StreamReader<T>>(1);
        this.streamIndexes = new HashMap<String, Map<Integer, Integer>>();
        this.snapshots = new HashMap<String, RS>();
        this.dispatchers = dispatchers;
        this.dispatchables = new CopyOnWriteArrayList<Dispatchable<Entry<T>, RS>>();
        InMemoryDispatcherControlDelegate dispatcherControlDelegate = new InMemoryDispatcherControlDelegate(this.dispatchables);
        this.dispatcherControl = (DispatcherControl)world.stage().actorFor(DispatcherControl.class, Definition.has(DispatcherControlActor.class, new DispatcherControl.DispatcherControlInstantiator(dispatchers, dispatcherControlDelegate, checkConfirmationExpirationInterval, confirmationExpiration)));
    }

    public InMemoryJournal(Dispatcher<Dispatchable<Entry<T>, RS>> dispatcher, World world) {
        this(Arrays.asList(dispatcher), world, 1000L, 1000L);
    }

    @Override
    public <S, ST> void append(String streamName, int streamVersion, Source<S> source, Metadata metadata, Journal.AppendResultInterest interest, Object object) {
        Object entry = this.entryAdapterProvider.asEntry(source, streamVersion, metadata);
        this.insert(streamName, streamVersion, (Entry<T>)entry);
        this.dispatch(streamName, streamVersion, Collections.singletonList(entry), null);
        interest.appendResultedIn((Outcome<StorageException, Result>)Success.of((Object)((Object)Result.Success)), streamName, streamVersion, source, Optional.empty(), object);
    }

    @Override
    public <S, ST> void appendWith(String streamName, int streamVersion, Source<S> source, Metadata metadata, ST snapshot, Journal.AppendResultInterest interest, Object object) {
        Optional<Object> snapshotResult;
        Object raw;
        Object entry = this.entryAdapterProvider.asEntry(source, streamVersion, metadata);
        this.insert(streamName, streamVersion, (Entry<T>)entry);
        if (snapshot != null) {
            raw = this.stateAdapterProvider.asRaw(streamName, snapshot, streamVersion);
            this.snapshots.put(streamName, raw);
            snapshotResult = Optional.of(snapshot);
        } else {
            raw = null;
            snapshotResult = Optional.empty();
        }
        this.dispatch(streamName, streamVersion, Collections.singletonList(entry), raw);
        interest.appendResultedIn((Outcome<StorageException, Result>)Success.of((Object)((Object)Result.Success)), streamName, streamVersion, source, snapshotResult, object);
    }

    @Override
    public <S, ST> void appendAll(String streamName, int fromStreamVersion, List<Source<S>> sources, Metadata metadata, Journal.AppendResultInterest interest, Object object) {
        List<Entry<T>> entries = this.entryAdapterProvider.asEntries(sources, fromStreamVersion, metadata);
        this.insert(streamName, fromStreamVersion, entries);
        this.dispatch(streamName, fromStreamVersion, entries, null);
        interest.appendAllResultedIn((Outcome<StorageException, Result>)Success.of((Object)((Object)Result.Success)), streamName, fromStreamVersion, sources, Optional.empty(), object);
    }

    @Override
    public <S, ST> void appendAllWith(String streamName, int fromStreamVersion, List<Source<S>> sources, Metadata metadata, ST snapshot, Journal.AppendResultInterest interest, Object object) {
        Optional<Object> snapshotResult;
        Object raw;
        List<Entry<T>> entries = this.entryAdapterProvider.asEntries(sources, fromStreamVersion, metadata);
        this.insert(streamName, fromStreamVersion, entries);
        if (snapshot != null) {
            raw = this.stateAdapterProvider.asRaw(streamName, snapshot, fromStreamVersion);
            this.snapshots.put(streamName, raw);
            snapshotResult = Optional.of(snapshot);
        } else {
            raw = null;
            snapshotResult = Optional.empty();
        }
        this.dispatch(streamName, fromStreamVersion, entries, raw);
        interest.appendAllResultedIn((Outcome<StorageException, Result>)Success.of((Object)((Object)Result.Success)), streamName, fromStreamVersion, sources, snapshotResult, object);
    }

    @Override
    public <ET extends Entry<?>> Completes<JournalReader<ET>> journalReader(String name) {
        JournalReader<? extends Entry<?>> reader = this.journalReaders.get(name);
        if (reader == null) {
            reader = new InMemoryJournalReader(this.journal, name);
            this.journalReaders.put(name, reader);
        }
        return Completes.withSuccess(reader);
    }

    @Override
    public Completes<StreamReader<T>> streamReader(String name) {
        StreamReader<T> reader = this.streamReaders.get(name);
        if (reader == null) {
            reader = new InMemoryStreamReader<T>(this.journal, this.streamIndexes, this.snapshots, name);
            this.streamReaders.put(name, reader);
        }
        return Completes.withSuccess(reader);
    }

    public void conclude() {
    }

    public boolean isStopped() {
        return false;
    }

    public void stop() {
        this.dispatcherControl.stop();
    }

    private void insert(String streamName, int streamVersion, Entry<T> entry) {
        int entryIndex = this.journal.size();
        String id = "" + (entryIndex + 1);
        ((BaseEntry)entry).__internal__setId(id);
        this.journal.add(entry);
        Map versionIndexes = this.streamIndexes.computeIfAbsent(streamName, k -> new HashMap());
        versionIndexes.put(streamVersion, entryIndex);
    }

    private void insert(String streamName, int fromStreamVersion, List<Entry<T>> entries) {
        int index = 0;
        for (Entry<T> entry : entries) {
            this.insert(streamName, fromStreamVersion + index, entry);
            ++index;
        }
    }

    private void dispatch(String streamName, int streamVersion, List<Entry<T>> entries, RS snapshot) {
        String id = InMemoryJournal.getDispatchId(streamName, streamVersion, entries);
        Dispatchable dispatchable = new Dispatchable(id, LocalDateTime.now(), snapshot, entries);
        this.dispatchables.add(dispatchable);
        this.dispatchers.forEach(d -> d.dispatch(dispatchable));
    }

    private static <T> String getDispatchId(String streamName, int streamVersion, Collection<Entry<T>> entries) {
        return streamName + ":" + streamVersion + ":" + entries.stream().map(Entry::id).collect(Collectors.joining(":"));
    }
}

