/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.symbio.store.journal.inmemory;

import io.vlingo.actors.Actor;
import io.vlingo.actors.ActorInstantiator;
import io.vlingo.actors.Definition;
import io.vlingo.common.Completes;
import io.vlingo.symbio.Entry;
import io.vlingo.symbio.EntryAdapterProvider;
import io.vlingo.symbio.Metadata;
import io.vlingo.symbio.Source;
import io.vlingo.symbio.State;
import io.vlingo.symbio.store.dispatch.Dispatchable;
import io.vlingo.symbio.store.dispatch.Dispatcher;
import io.vlingo.symbio.store.journal.Journal;
import io.vlingo.symbio.store.journal.JournalReader;
import io.vlingo.symbio.store.journal.StreamReader;
import io.vlingo.symbio.store.journal.inmemory.InMemoryJournal;
import io.vlingo.symbio.store.journal.inmemory.InMemoryJournalReader;
import io.vlingo.symbio.store.journal.inmemory.InMemoryJournalReaderActor;
import io.vlingo.symbio.store.journal.inmemory.InMemoryStreamReader;
import io.vlingo.symbio.store.journal.inmemory.InMemoryStreamReaderActor;
import java.util.List;

public class InMemoryJournalActor<T, RS extends State<?>>
extends Actor
implements Journal<T> {
    private final EntryAdapterProvider entryAdapterProvider;
    private final InMemoryJournal<T, RS> journal;

    public InMemoryJournalActor(Dispatcher<Dispatchable<Entry<T>, RS>> dispatcher) {
        this.journal = new InMemoryJournal<T, RS>(dispatcher, this.stage().world());
        this.entryAdapterProvider = EntryAdapterProvider.instance(this.stage().world());
    }

    @Override
    public <S, ST> void append(String streamName, int streamVersion, Source<S> source, Journal.AppendResultInterest interest, Object object) {
        this.journal.append(streamName, streamVersion, source, interest, object);
    }

    @Override
    public <S, ST> void append(String streamName, int streamVersion, Source<S> source, Metadata metadata, Journal.AppendResultInterest interest, Object object) {
        this.journal.append(streamName, streamVersion, source, metadata, interest, object);
    }

    @Override
    public <S, ST> void appendWith(String streamName, int streamVersion, Source<S> source, ST snapshot, Journal.AppendResultInterest interest, Object object) {
        this.journal.appendWith(streamName, streamVersion, source, snapshot, interest, object);
    }

    @Override
    public <S, ST> void appendWith(String streamName, int streamVersion, Source<S> source, Metadata metadata, ST snapshot, Journal.AppendResultInterest interest, Object object) {
        this.journal.appendWith(streamName, streamVersion, source, metadata, snapshot, interest, object);
    }

    @Override
    public <S, ST> void appendAll(String streamName, int fromStreamVersion, List<Source<S>> sources, Journal.AppendResultInterest interest, Object object) {
        this.journal.appendAll(streamName, fromStreamVersion, sources, interest, object);
    }

    @Override
    public <S, ST> void appendAll(String streamName, int fromStreamVersion, List<Source<S>> sources, Metadata metadata, Journal.AppendResultInterest interest, Object object) {
        this.journal.appendAll(streamName, fromStreamVersion, sources, metadata, interest, object);
    }

    @Override
    public <S, ST> void appendAllWith(String streamName, int fromStreamVersion, List<Source<S>> sources, ST snapshot, Journal.AppendResultInterest interest, Object object) {
        this.journal.appendAllWith(streamName, fromStreamVersion, sources, snapshot, interest, object);
    }

    @Override
    public <S, ST> void appendAllWith(String streamName, int fromStreamVersion, List<Source<S>> sources, Metadata metadata, ST snapshot, Journal.AppendResultInterest interest, Object object) {
        this.journal.appendAllWith(streamName, fromStreamVersion, sources, metadata, snapshot, interest, object);
    }

    @Override
    public <ET extends Entry<?>> Completes<JournalReader<ET>> journalReader(String name) {
        JournalReader inmemory = (JournalReader)this.journal.journalReader(name).outcome();
        JournalReader actor = (JournalReader)this.childActorFor(JournalReader.class, Definition.has(InMemoryJournalReaderActor.class, new InMemoryJournalReaderInstantiator(inmemory, this.entryAdapterProvider)));
        return this.completes().with((Object)actor);
    }

    @Override
    public Completes<StreamReader<T>> streamReader(String name) {
        StreamReader inmemory = (StreamReader)this.journal.streamReader(name).outcome();
        StreamReader actor = (StreamReader)this.childActorFor(StreamReader.class, Definition.has(InMemoryStreamReaderActor.class, new InMemoryStreamReaderInstantiator(inmemory)));
        return this.completes().with((Object)actor);
    }

    public void stop() {
        this.journal.stop();
        super.stop();
    }

    private static class InMemoryStreamReaderInstantiator<T extends Entry<?>>
    implements ActorInstantiator<InMemoryStreamReaderActor> {
        private static final long serialVersionUID = 5878161332125082127L;
        private final StreamReader<?> inmemory;

        InMemoryStreamReaderInstantiator(StreamReader<?> inmemory) {
            this.inmemory = inmemory;
        }

        public InMemoryStreamReaderActor<T> instantiate() {
            return new InMemoryStreamReaderActor((InMemoryStreamReader)this.inmemory);
        }

        public Class<InMemoryStreamReaderActor> type() {
            return InMemoryStreamReaderActor.class;
        }
    }

    private static class InMemoryJournalReaderInstantiator<T extends Entry<?>>
    implements ActorInstantiator<InMemoryJournalReaderActor> {
        private static final long serialVersionUID = -4704305821903232245L;
        private final EntryAdapterProvider entryAdapterProvider;
        private final JournalReader<T> inmemory;

        InMemoryJournalReaderInstantiator(JournalReader<T> inmemory, EntryAdapterProvider entryAdapterProvider) {
            this.inmemory = inmemory;
            this.entryAdapterProvider = entryAdapterProvider;
        }

        public InMemoryJournalReaderActor<T> instantiate() {
            return new InMemoryJournalReaderActor((InMemoryJournalReader)this.inmemory, this.entryAdapterProvider);
        }

        public Class<InMemoryJournalReaderActor> type() {
            return InMemoryJournalReaderActor.class;
        }
    }
}

